package com.github.houbb.jdbc.api.annotation;

import java.lang.annotation.*;

/**
 * 表注解
 * （1）统一加载：直接在程序加载的时候，提前加载好所有的实体和列信息。
 * @author binbin.hou
 * @since 0.0.1
 */
@Inherited
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface Entity {

    /**
     * 表名称
     * 1. 默认类名驼峰转为下划线大写
     * @return 表名称
     */
    String value() default "";

}
