package com.github.houbb.jdbc.api.annotation;

import com.github.houbb.constant.JdbcType;

import java.lang.annotation.*;

/**
 * 列注解
 * @author binbin.hou
 * @since 0.0.1
 */
@Inherited
@Documented
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.FIELD)
public @interface Column {

    /**
     * 列名称
     * 1. 默认类名驼峰转为下划线大写
     *
     * 注释：直接生成在注释上。
     * @return 表名称
     */
    String value() default "";

    /**
     * 执行 jdbc 类型
     *
     * 主要用于处理数据库的 date time timestamp 等各种类型的方式。
     * 当显式指定的时候，以这个类型为准。
     * @return jdbc 类型
     * @since 0.0.4
     */
    JdbcType jdbcType() default JdbcType.DEFAULT;

}
