/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.transcoders;

import net.rubyeye.xmemcached.transcoders.CachedData;
import net.rubyeye.xmemcached.transcoders.PrimitiveTypeTranscoder;

public class BooleanTranscoder
extends PrimitiveTypeTranscoder<Boolean> {
    public CachedData encode(Boolean l) {
        if (this.primitiveAsString) {
            byte[] b = this.encodeString(l.toString());
            int flags = 0;
            if (b.length > this.compressionThreshold) {
                byte[] compressed = this.compress(b);
                if (compressed.length < b.length) {
                    if (log.isDebugEnabled()) {
                        log.debug("Compressed " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                    }
                    b = compressed;
                    flags |= 2;
                } else if (log.isDebugEnabled()) {
                    log.debug("Compression increased the size of " + l.getClass().getName() + " from " + b.length + " to " + compressed.length);
                }
            }
            return new CachedData(flags, b, b.length, -1L);
        }
        return new CachedData(256, this.tu.encodeBoolean(l.booleanValue()));
    }

    public Boolean decode(CachedData d) {
        if (this.primitiveAsString) {
            int flag;
            byte[] data = d.getData();
            if ((d.getFlag() & 2) != 0) {
                data = this.decompress(d.getData());
            }
            if ((flag = d.getFlag()) == 0) {
                return Boolean.valueOf(this.decodeString(data));
            }
            return null;
        }
        if (256 == d.getFlag()) {
            return this.tu.decodeBoolean(d.getData());
        }
        return null;
    }

    public void setPrimitiveAsString(boolean primitiveAsString) {
        this.primitiveAsString = primitiveAsString;
    }

    public void setPackZeros(boolean packZeros) {
        this.tu.setPackZeros(packZeros);
    }
}

