/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xmemcached.spring.boot.geo;

import org.gavaghan.geodesy.Ellipsoid;
import org.gavaghan.geodesy.GeodeticCalculator;
import org.gavaghan.geodesy.GeodeticCurve;
import org.gavaghan.geodesy.GlobalCoordinates;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeoTemplate {
    private static final Logger log = LoggerFactory.getLogger(GeoTemplate.class);

    public double getDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        double lat1 = Math.PI / 180 * latitude1;
        double lat2 = Math.PI / 180 * latitude2;
        double lon1 = Math.PI / 180 * longitude1;
        double lon2 = Math.PI / 180 * longitude2;
        double R = 6371.0;
        double d = Math.acos(Math.sin(lat1) * Math.sin(lat2) + Math.cos(lat1) * Math.cos(lat2) * Math.cos(lon2 - lon1)) * R;
        return d * 1000.0;
    }

    public double getSphereDistance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.Sphere, latitude1, longitude1, latitude2, longitude2);
    }

    public double getWGS84Distance(double latitude1, double longitude1, double latitude2, double longitude2) {
        return this.getDistance(Ellipsoid.WGS84, latitude1, longitude1, latitude2, longitude2);
    }

    public double getDistance(Ellipsoid ellipsoid, double latitude1, double longitude1, double latitude2, double longitude2) {
        GlobalCoordinates gpsFrom = new GlobalCoordinates(latitude1, longitude1);
        GlobalCoordinates gpsTo = new GlobalCoordinates(latitude2, longitude2);
        return this.getDistance(gpsFrom, gpsTo, ellipsoid);
    }

    public double getDistance(GlobalCoordinates gpsFrom, GlobalCoordinates gpsTo, Ellipsoid ellipsoid) {
        GeodeticCurve geoCurve = new GeodeticCalculator().calculateGeodeticCurve(ellipsoid, gpsFrom, gpsTo);
        return geoCurve.getEllipsoidalDistance();
    }
}

