/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xmemcached.spring.boot;

import com.google.code.yanf4j.util.SystemUtils;
import java.time.Duration;
import net.rubyeye.xmemcached.MemcachedClient;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="spring.memcached")
public class XmemcachedProperties {
    public static final String PREFIX = "spring.memcached";
    private String addresses;
    private String weights;
    private Duration connectTimeout = Duration.ofMillis(60000L);
    private int connectionPoolSize = 1;
    private boolean failureMode;
    private boolean sanitizeKeys;
    private Duration opTimeout = Duration.ofMillis(5000L);
    private int maxQueuedNoReplyOperations = MemcachedClient.DEFAULT_MAX_QUEUED_NOPS;
    private long healSessionInterval = 2000L;
    private boolean enableHealSession = true;
    private boolean resolveInetAddresses = true;
    private Networking networking;
    private SocketOptions socketOptions;

    public String getAddresses() {
        return this.addresses;
    }

    public String getWeights() {
        return this.weights;
    }

    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getConnectionPoolSize() {
        return this.connectionPoolSize;
    }

    public boolean isFailureMode() {
        return this.failureMode;
    }

    public boolean isSanitizeKeys() {
        return this.sanitizeKeys;
    }

    public Duration getOpTimeout() {
        return this.opTimeout;
    }

    public int getMaxQueuedNoReplyOperations() {
        return this.maxQueuedNoReplyOperations;
    }

    public long getHealSessionInterval() {
        return this.healSessionInterval;
    }

    public boolean isEnableHealSession() {
        return this.enableHealSession;
    }

    public boolean isResolveInetAddresses() {
        return this.resolveInetAddresses;
    }

    public Networking getNetworking() {
        return this.networking;
    }

    public SocketOptions getSocketOptions() {
        return this.socketOptions;
    }

    public void setAddresses(String addresses) {
        this.addresses = addresses;
    }

    public void setWeights(String weights) {
        this.weights = weights;
    }

    public void setConnectTimeout(Duration connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setConnectionPoolSize(int connectionPoolSize) {
        this.connectionPoolSize = connectionPoolSize;
    }

    public void setFailureMode(boolean failureMode) {
        this.failureMode = failureMode;
    }

    public void setSanitizeKeys(boolean sanitizeKeys) {
        this.sanitizeKeys = sanitizeKeys;
    }

    public void setOpTimeout(Duration opTimeout) {
        this.opTimeout = opTimeout;
    }

    public void setMaxQueuedNoReplyOperations(int maxQueuedNoReplyOperations) {
        this.maxQueuedNoReplyOperations = maxQueuedNoReplyOperations;
    }

    public void setHealSessionInterval(long healSessionInterval) {
        this.healSessionInterval = healSessionInterval;
    }

    public void setEnableHealSession(boolean enableHealSession) {
        this.enableHealSession = enableHealSession;
    }

    public void setResolveInetAddresses(boolean resolveInetAddresses) {
        this.resolveInetAddresses = resolveInetAddresses;
    }

    public void setNetworking(Networking networking) {
        this.networking = networking;
    }

    public void setSocketOptions(SocketOptions socketOptions) {
        this.socketOptions = socketOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XmemcachedProperties)) {
            return false;
        }
        XmemcachedProperties other = (XmemcachedProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionPoolSize() != other.getConnectionPoolSize()) {
            return false;
        }
        if (this.isFailureMode() != other.isFailureMode()) {
            return false;
        }
        if (this.isSanitizeKeys() != other.isSanitizeKeys()) {
            return false;
        }
        if (this.getMaxQueuedNoReplyOperations() != other.getMaxQueuedNoReplyOperations()) {
            return false;
        }
        if (this.getHealSessionInterval() != other.getHealSessionInterval()) {
            return false;
        }
        if (this.isEnableHealSession() != other.isEnableHealSession()) {
            return false;
        }
        if (this.isResolveInetAddresses() != other.isResolveInetAddresses()) {
            return false;
        }
        String this$addresses = this.getAddresses();
        String other$addresses = other.getAddresses();
        if (this$addresses == null ? other$addresses != null : !this$addresses.equals(other$addresses)) {
            return false;
        }
        String this$weights = this.getWeights();
        String other$weights = other.getWeights();
        if (this$weights == null ? other$weights != null : !this$weights.equals(other$weights)) {
            return false;
        }
        Duration this$connectTimeout = this.getConnectTimeout();
        Duration other$connectTimeout = other.getConnectTimeout();
        if (this$connectTimeout == null ? other$connectTimeout != null : !((Object)this$connectTimeout).equals(other$connectTimeout)) {
            return false;
        }
        Duration this$opTimeout = this.getOpTimeout();
        Duration other$opTimeout = other.getOpTimeout();
        if (this$opTimeout == null ? other$opTimeout != null : !((Object)this$opTimeout).equals(other$opTimeout)) {
            return false;
        }
        Networking this$networking = this.getNetworking();
        Networking other$networking = other.getNetworking();
        if (this$networking == null ? other$networking != null : !((Object)this$networking).equals(other$networking)) {
            return false;
        }
        SocketOptions this$socketOptions = this.getSocketOptions();
        SocketOptions other$socketOptions = other.getSocketOptions();
        return !(this$socketOptions == null ? other$socketOptions != null : !((Object)this$socketOptions).equals(other$socketOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XmemcachedProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionPoolSize();
        result = result * 59 + (this.isFailureMode() ? 79 : 97);
        result = result * 59 + (this.isSanitizeKeys() ? 79 : 97);
        result = result * 59 + this.getMaxQueuedNoReplyOperations();
        long $healSessionInterval = this.getHealSessionInterval();
        result = result * 59 + (int)($healSessionInterval >>> 32 ^ $healSessionInterval);
        result = result * 59 + (this.isEnableHealSession() ? 79 : 97);
        result = result * 59 + (this.isResolveInetAddresses() ? 79 : 97);
        String $addresses = this.getAddresses();
        result = result * 59 + ($addresses == null ? 43 : $addresses.hashCode());
        String $weights = this.getWeights();
        result = result * 59 + ($weights == null ? 43 : $weights.hashCode());
        Duration $connectTimeout = this.getConnectTimeout();
        result = result * 59 + ($connectTimeout == null ? 43 : ((Object)$connectTimeout).hashCode());
        Duration $opTimeout = this.getOpTimeout();
        result = result * 59 + ($opTimeout == null ? 43 : ((Object)$opTimeout).hashCode());
        Networking $networking = this.getNetworking();
        result = result * 59 + ($networking == null ? 43 : ((Object)$networking).hashCode());
        SocketOptions $socketOptions = this.getSocketOptions();
        result = result * 59 + ($socketOptions == null ? 43 : ((Object)$socketOptions).hashCode());
        return result;
    }

    public String toString() {
        return "XmemcachedProperties(addresses=" + this.getAddresses() + ", weights=" + this.getWeights() + ", connectTimeout=" + this.getConnectTimeout() + ", connectionPoolSize=" + this.getConnectionPoolSize() + ", failureMode=" + this.isFailureMode() + ", sanitizeKeys=" + this.isSanitizeKeys() + ", opTimeout=" + this.getOpTimeout() + ", maxQueuedNoReplyOperations=" + this.getMaxQueuedNoReplyOperations() + ", healSessionInterval=" + this.getHealSessionInterval() + ", enableHealSession=" + this.isEnableHealSession() + ", resolveInetAddresses=" + this.isResolveInetAddresses() + ", networking=" + this.getNetworking() + ", socketOptions=" + this.getSocketOptions() + ")";
    }

    public static class SocketOptions {
        private boolean tcpNodelay = true;
        private int soRcvbuf = 65536;
        private boolean soKeepalive = true;
        private int soSndbuf = 32768;
        private int soLinger = 0;
        private boolean soReuseaddr = true;

        public boolean isTcpNodelay() {
            return this.tcpNodelay;
        }

        public int getSoRcvbuf() {
            return this.soRcvbuf;
        }

        public boolean isSoKeepalive() {
            return this.soKeepalive;
        }

        public int getSoSndbuf() {
            return this.soSndbuf;
        }

        public int getSoLinger() {
            return this.soLinger;
        }

        public boolean isSoReuseaddr() {
            return this.soReuseaddr;
        }

        public void setTcpNodelay(boolean tcpNodelay) {
            this.tcpNodelay = tcpNodelay;
        }

        public void setSoRcvbuf(int soRcvbuf) {
            this.soRcvbuf = soRcvbuf;
        }

        public void setSoKeepalive(boolean soKeepalive) {
            this.soKeepalive = soKeepalive;
        }

        public void setSoSndbuf(int soSndbuf) {
            this.soSndbuf = soSndbuf;
        }

        public void setSoLinger(int soLinger) {
            this.soLinger = soLinger;
        }

        public void setSoReuseaddr(boolean soReuseaddr) {
            this.soReuseaddr = soReuseaddr;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SocketOptions)) {
                return false;
            }
            SocketOptions other = (SocketOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isTcpNodelay() != other.isTcpNodelay()) {
                return false;
            }
            if (this.getSoRcvbuf() != other.getSoRcvbuf()) {
                return false;
            }
            if (this.isSoKeepalive() != other.isSoKeepalive()) {
                return false;
            }
            if (this.getSoSndbuf() != other.getSoSndbuf()) {
                return false;
            }
            if (this.getSoLinger() != other.getSoLinger()) {
                return false;
            }
            return this.isSoReuseaddr() == other.isSoReuseaddr();
        }

        protected boolean canEqual(Object other) {
            return other instanceof SocketOptions;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isTcpNodelay() ? 79 : 97);
            result = result * 59 + this.getSoRcvbuf();
            result = result * 59 + (this.isSoKeepalive() ? 79 : 97);
            result = result * 59 + this.getSoSndbuf();
            result = result * 59 + this.getSoLinger();
            result = result * 59 + (this.isSoReuseaddr() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "XmemcachedProperties.SocketOptions(tcpNodelay=" + this.isTcpNodelay() + ", soRcvbuf=" + this.getSoRcvbuf() + ", soKeepalive=" + this.isSoKeepalive() + ", soSndbuf=" + this.getSoSndbuf() + ", soLinger=" + this.getSoLinger() + ", soReuseaddr=" + this.isSoReuseaddr() + ")";
        }
    }

    public static class Networking {
        private int sessionReadBufferSize = 131072;
        private long sessionIdleTimeout = 5000L;
        private int soTimeout = 0;
        private int writeThreadCount = 0;
        private boolean statisticsServer = false;
        protected long statisticsInterval = 300000L;
        private boolean handleReadWriteConcurrently = true;
        private int dispatchMessageThreadCount = 0;
        private int readThreadCount = 1;
        private int selectorPoolSize = System.getProperty("xmemcached.selector.pool.size") == null ? SystemUtils.getSystemThreadCount() : Integer.parseInt(System.getProperty("xmemcached.selector.pool.size"));
        private long checkSessionTimeoutInterval = 1000L;

        public int getSessionReadBufferSize() {
            return this.sessionReadBufferSize;
        }

        public long getSessionIdleTimeout() {
            return this.sessionIdleTimeout;
        }

        public int getSoTimeout() {
            return this.soTimeout;
        }

        public int getWriteThreadCount() {
            return this.writeThreadCount;
        }

        public boolean isStatisticsServer() {
            return this.statisticsServer;
        }

        public long getStatisticsInterval() {
            return this.statisticsInterval;
        }

        public boolean isHandleReadWriteConcurrently() {
            return this.handleReadWriteConcurrently;
        }

        public int getDispatchMessageThreadCount() {
            return this.dispatchMessageThreadCount;
        }

        public int getReadThreadCount() {
            return this.readThreadCount;
        }

        public int getSelectorPoolSize() {
            return this.selectorPoolSize;
        }

        public long getCheckSessionTimeoutInterval() {
            return this.checkSessionTimeoutInterval;
        }

        public void setSessionReadBufferSize(int sessionReadBufferSize) {
            this.sessionReadBufferSize = sessionReadBufferSize;
        }

        public void setSessionIdleTimeout(long sessionIdleTimeout) {
            this.sessionIdleTimeout = sessionIdleTimeout;
        }

        public void setSoTimeout(int soTimeout) {
            this.soTimeout = soTimeout;
        }

        public void setWriteThreadCount(int writeThreadCount) {
            this.writeThreadCount = writeThreadCount;
        }

        public void setStatisticsServer(boolean statisticsServer) {
            this.statisticsServer = statisticsServer;
        }

        public void setStatisticsInterval(long statisticsInterval) {
            this.statisticsInterval = statisticsInterval;
        }

        public void setHandleReadWriteConcurrently(boolean handleReadWriteConcurrently) {
            this.handleReadWriteConcurrently = handleReadWriteConcurrently;
        }

        public void setDispatchMessageThreadCount(int dispatchMessageThreadCount) {
            this.dispatchMessageThreadCount = dispatchMessageThreadCount;
        }

        public void setReadThreadCount(int readThreadCount) {
            this.readThreadCount = readThreadCount;
        }

        public void setSelectorPoolSize(int selectorPoolSize) {
            this.selectorPoolSize = selectorPoolSize;
        }

        public void setCheckSessionTimeoutInterval(long checkSessionTimeoutInterval) {
            this.checkSessionTimeoutInterval = checkSessionTimeoutInterval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Networking)) {
                return false;
            }
            Networking other = (Networking)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSessionReadBufferSize() != other.getSessionReadBufferSize()) {
                return false;
            }
            if (this.getSessionIdleTimeout() != other.getSessionIdleTimeout()) {
                return false;
            }
            if (this.getSoTimeout() != other.getSoTimeout()) {
                return false;
            }
            if (this.getWriteThreadCount() != other.getWriteThreadCount()) {
                return false;
            }
            if (this.isStatisticsServer() != other.isStatisticsServer()) {
                return false;
            }
            if (this.getStatisticsInterval() != other.getStatisticsInterval()) {
                return false;
            }
            if (this.isHandleReadWriteConcurrently() != other.isHandleReadWriteConcurrently()) {
                return false;
            }
            if (this.getDispatchMessageThreadCount() != other.getDispatchMessageThreadCount()) {
                return false;
            }
            if (this.getReadThreadCount() != other.getReadThreadCount()) {
                return false;
            }
            if (this.getSelectorPoolSize() != other.getSelectorPoolSize()) {
                return false;
            }
            return this.getCheckSessionTimeoutInterval() == other.getCheckSessionTimeoutInterval();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Networking;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSessionReadBufferSize();
            long $sessionIdleTimeout = this.getSessionIdleTimeout();
            result = result * 59 + (int)($sessionIdleTimeout >>> 32 ^ $sessionIdleTimeout);
            result = result * 59 + this.getSoTimeout();
            result = result * 59 + this.getWriteThreadCount();
            result = result * 59 + (this.isStatisticsServer() ? 79 : 97);
            long $statisticsInterval = this.getStatisticsInterval();
            result = result * 59 + (int)($statisticsInterval >>> 32 ^ $statisticsInterval);
            result = result * 59 + (this.isHandleReadWriteConcurrently() ? 79 : 97);
            result = result * 59 + this.getDispatchMessageThreadCount();
            result = result * 59 + this.getReadThreadCount();
            result = result * 59 + this.getSelectorPoolSize();
            long $checkSessionTimeoutInterval = this.getCheckSessionTimeoutInterval();
            result = result * 59 + (int)($checkSessionTimeoutInterval >>> 32 ^ $checkSessionTimeoutInterval);
            return result;
        }

        public String toString() {
            return "XmemcachedProperties.Networking(sessionReadBufferSize=" + this.getSessionReadBufferSize() + ", sessionIdleTimeout=" + this.getSessionIdleTimeout() + ", soTimeout=" + this.getSoTimeout() + ", writeThreadCount=" + this.getWriteThreadCount() + ", statisticsServer=" + this.isStatisticsServer() + ", statisticsInterval=" + this.getStatisticsInterval() + ", handleReadWriteConcurrently=" + this.isHandleReadWriteConcurrently() + ", dispatchMessageThreadCount=" + this.getDispatchMessageThreadCount() + ", readThreadCount=" + this.getReadThreadCount() + ", selectorPoolSize=" + this.getSelectorPoolSize() + ", checkSessionTimeoutInterval=" + this.getCheckSessionTimeoutInterval() + ")";
        }
    }
}

