/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xmemcached.spring.boot;

import com.googlecode.xmemcached.spring.boot.XMemcachedOperationException;
import com.googlecode.xmemcached.spring.boot.XmemcachedKey;
import com.googlecode.xmemcached.spring.boot.XmemcachedProperties;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.rubyeye.xmemcached.CASOperation;
import net.rubyeye.xmemcached.Counter;
import net.rubyeye.xmemcached.GetsResponse;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class XmemcachedOperationTemplate {
    private static final Logger log = LoggerFactory.getLogger(XmemcachedOperationTemplate.class);
    public static final Function<Object, String> TO_STRING = member -> Objects.toString(member, null);
    public static final Function<Object, Double> TO_DOUBLE = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Double ? ((Double)member).doubleValue() : new BigDecimal(member.toString()).doubleValue();
    };
    public static final Function<Object, Long> TO_LONG = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Long ? ((Long)member).longValue() : new BigDecimal(member.toString()).longValue();
    };
    public static final Function<Object, Integer> TO_INTEGER = member -> {
        if (Objects.isNull(member)) {
            return null;
        }
        return member instanceof Integer ? ((Integer)member).intValue() : new BigDecimal(member.toString()).intValue();
    };
    XMemcachedClient xMemcachedClient;
    XmemcachedProperties xMemcachedProperties;
    long optTimeout;

    public XmemcachedOperationTemplate(XMemcachedClient xMemcachedClient, XmemcachedProperties xMemcachedProperties) {
        this.xMemcachedClient = xMemcachedClient;
        this.xMemcachedProperties = xMemcachedProperties;
        this.optTimeout = xMemcachedProperties.getOpTimeout().getSeconds();
    }

    public Counter counter(String key) {
        try {
            return this.xMemcachedClient.getCounter(key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Counter counter(String key, long initialValue) {
        try {
            return this.xMemcachedClient.getCounter(key, initialValue);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public boolean append(String key, Object value) {
        try {
            return this.xMemcachedClient.append(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public void appendWithNoReply(String key, Object value) {
        try {
            this.xMemcachedClient.appendWithNoReply(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public boolean prepend(String key, Object value) {
        try {
            return this.xMemcachedClient.prepend(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public void prependWithNoReply(String key, Object value) {
        try {
            this.xMemcachedClient.prependWithNoReply(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean setIfAbsent(String key, T value) {
        try {
            return this.xMemcachedClient.add(key, 0, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean setIfAbsent(String key, T value, int seconds) {
        try {
            return this.xMemcachedClient.add(key, seconds, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean cas(String key, T value) {
        return this.cas(key, value, 0);
    }

    public <T> boolean cas(String key, T value, int seconds) {
        try {
            GetsResponse result = this.xMemcachedClient.gets(key);
            if (Objects.isNull(result)) {
                return this.xMemcachedClient.add(key, seconds, value);
            }
            return this.xMemcachedClient.cas(key, seconds, value, result.getCas());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean cas(String key, T value, Duration timeout) {
        if (Objects.isNull(timeout) || timeout.isNegative()) {
            return false;
        }
        return this.cas(key, value, Long.valueOf(timeout.getSeconds()).intValue());
    }

    public <T> boolean cas(String key, T value, int seconds, long cas) {
        try {
            return this.xMemcachedClient.cas(key, seconds, value, cas);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> void casWithNoReply(String key, CASOperation<T> operation) {
        try {
            this.xMemcachedClient.casWithNoReply(key, operation);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean set(String key, T value) {
        try {
            return this.xMemcachedClient.set(key, 0, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean set(String key, T value, int seconds) {
        try {
            if (seconds > 0) {
                return this.xMemcachedClient.set(key, seconds, value);
            }
            return this.set(key, value);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> boolean set(String key, T value, Duration timeout) {
        if (Objects.isNull(timeout) || timeout.isNegative()) {
            return false;
        }
        return this.set(key, value, Long.valueOf(timeout.getSeconds()).intValue());
    }

    public <T> T get(String key) {
        try {
            return (T)this.xMemcachedClient.get(key);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public String getString(String key) {
        return this.getFor(key, TO_STRING);
    }

    public String getString(String key, String defaultVal) {
        String rtVal = this.getString(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Double getDouble(String key) {
        return this.getFor(key, TO_DOUBLE);
    }

    public Double getDouble(String key, double defaultVal) {
        Double rtVal = this.getDouble(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Long getLong(String key) {
        return this.getFor(key, TO_LONG);
    }

    public Long getLong(String key, long defaultVal) {
        Long rtVal = this.getLong(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public Integer getInteger(String key) {
        return this.getFor(key, TO_INTEGER);
    }

    public Integer getInteger(String key, int defaultVal) {
        Integer rtVal = this.getInteger(key);
        return Objects.nonNull(rtVal) ? rtVal : defaultVal;
    }

    public <T> T getFor(String key, Class<T> clazz) {
        return (T)this.getFor(key, (Object member) -> clazz.cast(member));
    }

    public <T> T getFor(String key, Function<Object, T> mapper) {
        T obj = this.get(key);
        if (Objects.nonNull(obj)) {
            return mapper.apply(obj);
        }
        return null;
    }

    public <T> T getFor(String key, Transcoder<T> transcoder) {
        try {
            return (T)this.xMemcachedClient.get(key, transcoder);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Map<String, Long> mGetLong(Collection<String> keys) {
        return this.mGetFor(keys, TO_LONG);
    }

    public Map<String, Integer> mGetInteger(Collection<String> keys) {
        return this.mGetFor(keys, TO_INTEGER);
    }

    public Map<String, String> mGetString(Collection<String> keys) {
        return this.mGetFor(keys, TO_STRING);
    }

    public <T> Map<String, T> mGetFor(Collection keys, Class<T> clazz) {
        return this.mGetFor(keys, (Object member) -> clazz.cast(member));
    }

    public <T> Map<String, T> mGetFor(Collection keys, Function<Object, T> mapper) {
        Map<String, T> members = this.mGet(keys);
        if (Objects.nonNull(members)) {
            return members.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, mapper));
        }
        return null;
    }

    public <T> Map<String, T> mGetFor(Collection<String> keys, Transcoder<T> transcoder) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Collections.emptyMap();
            }
            return this.xMemcachedClient.get(keys, transcoder);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> Map<String, T> mGet(Collection<String> keys) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Collections.emptyMap();
            }
            return this.xMemcachedClient.get(keys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public <T> Map<String, T> mGet(Collection<Object> keys, String redisPrefix) {
        try {
            if (CollectionUtils.isEmpty(keys)) {
                return Collections.emptyMap();
            }
            Collection newKeys = keys.stream().map(key -> XmemcachedKey.getKeyStr(redisPrefix, key.toString())).collect(Collectors.toList());
            return this.xMemcachedClient.get(newKeys);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.xMemcachedClient.incr(key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public void incrWithNoReply(String key, long delta) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            this.xMemcachedClient.incrWithNoReply(key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta, int seconds) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            if (seconds > 0) {
                return this.xMemcachedClient.incr(key, delta, 0L, this.optTimeout, seconds);
            }
            return this.xMemcachedClient.incr(key, delta, 0L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long incr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u589e\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            if (!timeout.isNegative()) {
                return this.xMemcachedClient.incr(key, delta, 0L, this.optTimeout, Long.valueOf(timeout.getSeconds()).intValue());
            }
            return this.xMemcachedClient.incr(key, delta, 0L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            return this.xMemcachedClient.decr(key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public void decrWithNoReply(String key, long delta) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            this.xMemcachedClient.decrWithNoReply(key, delta);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta, int seconds) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            if (seconds > 0) {
                return this.xMemcachedClient.decr(key, delta, 0L, this.optTimeout, seconds);
            }
            return this.xMemcachedClient.decr(key, delta, 0L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public Long decr(String key, long delta, Duration timeout) {
        if (delta < 0L) {
            throw new XMemcachedOperationException("\u9012\u51cf\u56e0\u5b50\u5fc5\u987b>=0");
        }
        try {
            if (!timeout.isNegative()) {
                return this.xMemcachedClient.decr(key, delta, 0L, this.optTimeout, Long.valueOf(timeout.getSeconds()).intValue());
            }
            return this.xMemcachedClient.decr(key, delta, 0L);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }

    public void del(String ... keys) {
        try {
            if (Objects.nonNull(keys) && keys.length > 0) {
                for (String key : keys) {
                    this.xMemcachedClient.delete(key);
                }
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new XMemcachedOperationException(e.getMessage());
        }
    }
}

