/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xmemcached.spring.boot;

import java.util.Objects;
import java.util.StringJoiner;
import java.util.function.Function;
import org.springframework.util.StringUtils;

public enum XmemcachedKey {
    USER_GEO_LOCATION("\u7528\u6237\u5750\u6807", userId -> XmemcachedKey.getKeyStr("user:geo:location"));

    private String desc;
    private Function<Object, String> function;
    public static String REDIS_PREFIX;
    public static final String DELIMITER = ":";

    private XmemcachedKey(String desc, Function<Object, String> function) {
        this.desc = desc;
        this.function = function;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getKey() {
        return this.function.apply(null);
    }

    public String getKey(Object key) {
        return this.function.apply(key);
    }

    public static String getKeyStr(Object ... args) {
        StringJoiner tempKey = new StringJoiner(DELIMITER);
        tempKey.add(REDIS_PREFIX);
        for (Object s : args) {
            if (Objects.isNull(s) || !StringUtils.hasText((String)s.toString())) continue;
            tempKey.add(s.toString());
        }
        return tempKey.toString();
    }

    public static String getThreadKeyStr(String prefix, Object ... args) {
        StringJoiner tempKey = new StringJoiner(DELIMITER);
        tempKey.add(prefix);
        tempKey.add(String.valueOf(Thread.currentThread().getId()));
        for (Object s : args) {
            if (Objects.isNull(s) || !StringUtils.hasText((String)s.toString())) continue;
            tempKey.add(s.toString());
        }
        return tempKey.toString();
    }

    public static void main(String[] args) {
        System.out.println(XmemcachedKey.getKeyStr(233, ""));
    }

    static {
        REDIS_PREFIX = "rds";
    }
}

