/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.xmemcached.spring.boot;

import com.google.code.yanf4j.core.impl.StandardSocketOption;
import com.googlecode.xmemcached.spring.boot.AuthInfoProvider;
import com.googlecode.xmemcached.spring.boot.XmemcachedOperationTemplate;
import com.googlecode.xmemcached.spring.boot.XmemcachedProperties;
import java.io.IOException;
import java.util.Objects;
import java.util.stream.Stream;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.KeyProvider;
import net.rubyeye.xmemcached.MemcachedSessionComparator;
import net.rubyeye.xmemcached.MemcachedSessionLocator;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClientBuilder;
import net.rubyeye.xmemcached.command.BinaryCommandFactory;
import net.rubyeye.xmemcached.impl.DefaultKeyProvider;
import net.rubyeye.xmemcached.impl.IndexMemcachedSessionComparator;
import net.rubyeye.xmemcached.impl.KetamaMemcachedSessionLocator;
import net.rubyeye.xmemcached.utils.AddrUtil;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={XMemcachedClient.class})
@EnableConfigurationProperties(value={XmemcachedProperties.class})
public class XmemcachedAutoConfiguration {
    @Bean(destroyMethod="shutdown")
    public XMemcachedClient xMemcachedClient(ObjectProvider<KeyProvider> keyProvider, ObjectProvider<AuthInfoProvider> authInfoProvider, ObjectProvider<CommandFactory> commandFactoryProvider, ObjectProvider<MemcachedSessionComparator> sessionComparatorProvider, ObjectProvider<MemcachedSessionLocator> sessionLocatorProvider, XmemcachedProperties xMemcachedProperties) throws IOException {
        XmemcachedProperties.SocketOptions socketOptions;
        XMemcachedClientBuilder builder;
        Objects.requireNonNull(xMemcachedProperties.getAddresses());
        if (StringUtils.hasText((String)xMemcachedProperties.getWeights())) {
            int[] weights = Stream.of(StringUtils.tokenizeToStringArray((String)xMemcachedProperties.getWeights(), (String)",")).mapToInt(weight -> Integer.parseInt(weight)).toArray();
            builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)xMemcachedProperties.getAddresses()), weights);
        } else {
            builder = new XMemcachedClientBuilder(AddrUtil.getAddresses((String)xMemcachedProperties.getAddresses()));
        }
        builder.setAuthInfoMap(((AuthInfoProvider)authInfoProvider.getIfAvailable(() -> new AuthInfoProvider(){})).getAuthInfoMap());
        builder.setFailureMode(xMemcachedProperties.isFailureMode());
        builder.setCommandFactory((CommandFactory)commandFactoryProvider.getIfAvailable(() -> new BinaryCommandFactory()));
        builder.setConnectionPoolSize(xMemcachedProperties.getConnectionPoolSize());
        builder.setConnectTimeout(xMemcachedProperties.getConnectTimeout().toMillis());
        builder.setEnableHealSession(xMemcachedProperties.isEnableHealSession());
        builder.setHealSessionInterval(xMemcachedProperties.getHealSessionInterval());
        builder.setKeyProvider((KeyProvider)keyProvider.getIfAvailable(() -> DefaultKeyProvider.INSTANCE));
        builder.setMaxQueuedNoReplyOperations(xMemcachedProperties.getMaxQueuedNoReplyOperations());
        builder.setOpTimeout(xMemcachedProperties.getOpTimeout().toMillis());
        builder.setResolveInetAddresses(xMemcachedProperties.isResolveInetAddresses());
        builder.setSessionComparator((MemcachedSessionComparator)sessionComparatorProvider.getIfAvailable(() -> new IndexMemcachedSessionComparator()));
        builder.setSessionLocator((MemcachedSessionLocator)sessionLocatorProvider.getIfAvailable(() -> new KetamaMemcachedSessionLocator()));
        builder.setSanitizeKeys(xMemcachedProperties.isSanitizeKeys());
        XmemcachedProperties.Networking networking = xMemcachedProperties.getNetworking();
        if (Objects.nonNull(networking)) {
            com.google.code.yanf4j.config.Configuration configuration = new com.google.code.yanf4j.config.Configuration();
            configuration.setCheckSessionTimeoutInterval(networking.getCheckSessionTimeoutInterval());
            configuration.setDispatchMessageThreadCount(networking.getDispatchMessageThreadCount());
            configuration.setHandleReadWriteConcurrently(networking.isHandleReadWriteConcurrently());
            configuration.setReadThreadCount(networking.getReadThreadCount());
            configuration.setSessionReadBufferSize(networking.getSessionReadBufferSize());
            configuration.setSessionIdleTimeout(networking.getSessionIdleTimeout());
            configuration.setSelectorPoolSize(networking.getSelectorPoolSize());
            configuration.setSoTimeout(networking.getSoTimeout());
            configuration.setStatisticsInterval(networking.getStatisticsInterval());
            configuration.setStatisticsServer(networking.isStatisticsServer());
            configuration.setWriteThreadCount(networking.getWriteThreadCount());
            builder.setConfiguration(configuration);
        }
        if (Objects.nonNull(socketOptions = xMemcachedProperties.getSocketOptions())) {
            builder.setSocketOption(StandardSocketOption.TCP_NODELAY, (Object)socketOptions.isTcpNodelay());
            builder.setSocketOption(StandardSocketOption.SO_RCVBUF, (Object)socketOptions.getSoRcvbuf());
            builder.setSocketOption(StandardSocketOption.SO_KEEPALIVE, (Object)socketOptions.isSoKeepalive());
            builder.setSocketOption(StandardSocketOption.SO_SNDBUF, (Object)socketOptions.getSoSndbuf());
            builder.setSocketOption(StandardSocketOption.SO_LINGER, (Object)socketOptions.getSoLinger());
            builder.setSocketOption(StandardSocketOption.SO_REUSEADDR, (Object)socketOptions.isSoReuseaddr());
        }
        return (XMemcachedClient)builder.build();
    }

    @Bean
    public XmemcachedOperationTemplate xmemcachedOperationTemplate(XMemcachedClient xMemcachedClient, XmemcachedProperties xMemcachedProperties) {
        return new XmemcachedOperationTemplate(xMemcachedClient, xMemcachedProperties);
    }
}

