/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication.server;

import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.springframework.http.HttpCookie;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationToken;
import org.springframework.security.boot.jwt.exception.AuthenticationJwtNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.ReactiveSecurityContextHolder;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

public class JwtServerAuthorizationSecurityContextRepository
implements ServerSecurityContextRepository {
    public static final String DEFAULT_LONGITUDE_LATITUDE = "0.000000";
    public static final String AUTHORIZATION_PARAM = "token";
    public static final String AUTHORIZATION_HEADER = "X-Authorization";
    public static final String UID_HEADER = "X-Uid";
    public static final String SIGN_HEADER = "X-Sign";
    public static final String LONGITUDE_HEADER = "X-Longitude";
    public static final String LATITUDE_HEADER = "X-Latitude";
    private String authorizationHeaderName = "X-Authorization";
    private String authorizationParamName = "token";
    private String authorizationCookieName = "token";
    private String uidHeaderName = "X-Uid";
    private String signHeaderName = "X-Sign";
    private String longitudeHeaderName = "X-Longitude";
    private String latitudeHeaderName = "X-Latitude";
    private ReactiveAuthenticationManager authenticationManager;
    private String[] whiteList;
    private AntPathMatcher antPathMatcher = new AntPathMatcher();

    public JwtServerAuthorizationSecurityContextRepository(ReactiveAuthenticationManager authenticationManager, String ... whiteList) {
        this.authenticationManager = authenticationManager;
        this.whiteList = whiteList;
    }

    public Mono<Void> save(ServerWebExchange serverWebExchange, SecurityContext securityContext) {
        return Mono.empty();
    }

    public Mono<SecurityContext> load(ServerWebExchange serverWebExchange) {
        ServerHttpRequest request = serverWebExchange.getRequest();
        boolean match = Stream.of(this.whiteList).anyMatch(path -> this.getAntPathMatcher().match(path, request.getPath().toString()));
        if (match) {
            return Mono.empty();
        }
        return Mono.just((Object)request).flatMap(matchResult -> Mono.just((Object)this.obtainToken(request))).switchIfEmpty(Mono.defer(() -> Mono.error((Throwable)((Object)new AuthenticationJwtNotFoundException("Token not provided"))))).flatMap(token -> {
            JwtAuthorizationToken authRequest = new JwtAuthorizationToken(this.obtainUid(request), token);
            authRequest.setLongitude(this.obtainLongitude(request));
            authRequest.setLatitude(this.obtainLatitude(request));
            authRequest.setSign(this.obtainSign(request));
            return Mono.justOrEmpty((Object)((Object)authRequest));
        }).flatMap(authRequest -> this.authenticationManager.authenticate((Authentication)authRequest)).flatMap(authentication -> this.onAuthenticationSuccess((Authentication)authentication, serverWebExchange));
    }

    protected Mono<SecurityContext> onAuthenticationSuccess(Authentication authentication, ServerWebExchange exchange) {
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
        return Mono.just((Object)securityContext).subscriberContext(ReactiveSecurityContextHolder.withSecurityContext((Mono)Mono.just((Object)securityContext))).cast(SecurityContext.class);
    }

    public AntPathMatcher getAntPathMatcher() {
        return this.antPathMatcher;
    }

    public void setAntPathMatcher(AntPathMatcher antPathMatcher) {
        this.antPathMatcher = antPathMatcher;
    }

    public String[] getWhiteList() {
        return this.whiteList;
    }

    protected String obtainUid(ServerHttpRequest request) {
        return request.getHeaders().getFirst(this.getUidHeaderName());
    }

    protected double obtainLongitude(ServerHttpRequest request) {
        return Double.parseDouble((String)StringUtils.defaultIfBlank((CharSequence)request.getHeaders().getFirst(this.getLongitudeHeaderName()), (CharSequence)DEFAULT_LONGITUDE_LATITUDE));
    }

    protected double obtainLatitude(ServerHttpRequest request) {
        return Double.parseDouble((String)StringUtils.defaultIfBlank((CharSequence)request.getHeaders().getFirst(this.getLatitudeHeaderName()), (CharSequence)DEFAULT_LONGITUDE_LATITUDE));
    }

    protected String obtainSign(ServerHttpRequest request) {
        return request.getHeaders().getFirst(this.getSignHeaderName());
    }

    protected String obtainToken(ServerHttpRequest request) {
        String token = request.getHeaders().getFirst(this.getAuthorizationHeaderName());
        if (StringUtils.isEmpty((CharSequence)token)) {
            return (String)request.getQueryParams().getFirst((Object)this.getAuthorizationParamName());
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            MultiValueMap cookies = request.getCookies();
            if (null == cookies || cookies.size() == 0) {
                return null;
            }
            HttpCookie cookie = (HttpCookie)request.getCookies().getFirst((Object)this.getAuthorizationCookieName());
            if (!Objects.isNull(cookie)) {
                token = cookie.getValue();
            }
        }
        if (token == null) {
            token = "";
        }
        return token.trim();
    }

    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    public String getAuthorizationParamName() {
        return this.authorizationParamName;
    }

    public void setAuthorizationParamName(String authorizationParamName) {
        this.authorizationParamName = authorizationParamName;
    }

    public String getAuthorizationCookieName() {
        return this.authorizationCookieName;
    }

    public void setAuthorizationCookieName(String authorizationCookieName) {
        this.authorizationCookieName = authorizationCookieName;
    }

    public String getUidHeaderName() {
        return this.uidHeaderName;
    }

    public void setUidHeaderName(String uidHeaderName) {
        this.uidHeaderName = uidHeaderName;
    }

    public String getSignHeaderName() {
        return this.signHeaderName;
    }

    public void setSignHeaderName(String signHeaderName) {
        this.signHeaderName = signHeaderName;
    }

    public String getLongitudeHeaderName() {
        return this.longitudeHeaderName;
    }

    public void setLongitudeHeaderName(String longitudeHeaderName) {
        this.longitudeHeaderName = longitudeHeaderName;
    }

    public String getLatitudeHeaderName() {
        return this.latitudeHeaderName;
    }

    public void setLatitudeHeaderName(String latitudeHeaderName) {
        this.latitudeHeaderName = latitudeHeaderName;
    }

    public ReactiveAuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(ReactiveAuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }
}

