/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication.server;

import com.github.hiwepy.jwt.JwtPayload;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.boot.biz.userdetails.JwtPayloadRepository;
import org.springframework.security.boot.biz.userdetails.SecurityPrincipal;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationToken;
import org.springframework.security.boot.jwt.exception.AuthenticationJwtExpiredException;
import org.springframework.security.boot.jwt.exception.AuthenticationJwtInvalidException;
import org.springframework.security.boot.jwt.exception.AuthenticationJwtNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class JwtReactiveAuthenticationManager
implements ReactiveAuthenticationManager {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final JwtPayloadRepository payloadRepository;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();
    private boolean checkExpiry = false;
    private boolean checkPrincipal = false;

    public JwtReactiveAuthenticationManager(JwtPayloadRepository payloadRepository) {
        this.payloadRepository = payloadRepository;
    }

    public Mono<Authentication> authenticate(Authentication authentication) {
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing authentication request : " + authentication);
        }
        String xuid = (String)authentication.getPrincipal();
        String token = (String)authentication.getCredentials();
        if (StringUtils.isBlank((CharSequence)token)) {
            this.logger.debug("No JWT found in request.");
            throw new AuthenticationJwtNotFoundException("No JWT found in request.");
        }
        JwtAuthorizationToken jwtToken = (JwtAuthorizationToken)authentication;
        if (this.isCheckExpiry() && !this.getPayloadRepository().verify((AbstractAuthenticationToken)jwtToken, this.isCheckExpiry())) {
            throw new AuthenticationJwtExpiredException("Token Expired");
        }
        JwtPayload payload = this.getPayloadRepository().getPayload((AbstractAuthenticationToken)jwtToken, this.checkExpiry);
        if (this.isCheckPrincipal() && !StringUtils.equals((CharSequence)xuid, (CharSequence)payload.getClientId())) {
            throw new AuthenticationJwtInvalidException("Token Invalid");
        }
        HashSet<SimpleGrantedAuthority> grantedAuthorities = new HashSet<SimpleGrantedAuthority>();
        SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority("ROLE_" + payload.getRkey());
        grantedAuthorities.add(grantedAuthority);
        Set perms = payload.getPerms();
        for (String perm : perms) {
            SimpleGrantedAuthority authority = new SimpleGrantedAuthority(perm);
            grantedAuthorities.add(authority);
        }
        Map claims = payload.getClaims();
        String uid = StringUtils.defaultString((String)MapUtils.getString((Map)claims, (Object)"uid"), (String)payload.getClientId());
        SecurityPrincipal principal = new SecurityPrincipal(uid, payload.getTokenId(), payload.isEnabled(), payload.isAccountNonExpired(), payload.isCredentialsNonExpired(), payload.isAccountNonLocked(), grantedAuthorities);
        principal.setUid(uid);
        principal.setUuid(payload.getUuid());
        principal.setUkey(payload.getUkey());
        principal.setUcode(payload.getUcode());
        principal.setPerms(new HashSet(perms));
        principal.setRid(payload.getRid());
        principal.setRkey(payload.getRkey());
        principal.setRoles(payload.getRoles());
        principal.setBound(payload.isBound());
        principal.setInitial(payload.isInitial());
        principal.setProfile(payload.getProfile());
        principal.setSign(jwtToken.getSign());
        principal.setLongitude(jwtToken.getLongitude());
        principal.setLatitude(jwtToken.getLatitude());
        this.getUserDetailsChecker().check((UserDetails)principal);
        JwtAuthorizationToken authenticationToken = new JwtAuthorizationToken(principal, payload, principal.getAuthorities());
        authenticationToken.setDetails(authentication.getDetails());
        return Mono.justOrEmpty((Object)((Object)authenticationToken));
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public UserDetailsChecker getUserDetailsChecker() {
        return this.userDetailsChecker;
    }

    public JwtPayloadRepository getPayloadRepository() {
        return this.payloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }

    public boolean isCheckPrincipal() {
        return this.checkPrincipal;
    }

    public void setCheckPrincipal(boolean checkPrincipal) {
        this.checkPrincipal = checkPrincipal;
    }
}

