/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication.server;

import com.alibaba.fastjson.JSONObject;
import java.nio.charset.StandardCharsets;
import org.reactivestreams.Publisher;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.boot.biz.SpringSecurityBizMessageSource;
import org.springframework.security.boot.biz.authentication.server.MatchedServerAuthenticationSuccessHandler;
import org.springframework.security.boot.biz.exception.AuthResponse;
import org.springframework.security.boot.biz.exception.AuthResponseCode;
import org.springframework.security.boot.biz.userdetails.JwtPayloadRepository;
import org.springframework.security.boot.biz.userdetails.UserProfilePayload;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationToken;
import org.springframework.security.boot.utils.SubjectUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.server.WebFilterExchange;
import reactor.core.publisher.Mono;

public class JwtMatchedServerAuthenticationSuccessHandler
implements MatchedServerAuthenticationSuccessHandler {
    protected MessageSourceAccessor messages = SpringSecurityBizMessageSource.getAccessor();
    private JwtPayloadRepository payloadRepository;
    private boolean checkExpiry = false;

    public JwtMatchedServerAuthenticationSuccessHandler(JwtPayloadRepository payloadRepository, boolean checkExpiry) {
        this.setPayloadRepository(payloadRepository);
        this.checkExpiry = checkExpiry;
    }

    public boolean supports(Authentication authentication) {
        return SubjectUtils.isAssignableFrom(authentication.getClass(), (Class[])new Class[]{JwtAuthenticationToken.class});
    }

    public Mono<Void> onAuthenticationSuccess(WebFilterExchange webFilterExchange, Authentication authentication) {
        ServerHttpResponse response = webFilterExchange.getExchange().getResponse();
        response.setStatusCode(HttpStatus.OK);
        response.getHeaders().setContentType(MediaType.APPLICATION_JSON);
        String message = this.messages.getMessage(AuthResponseCode.SC_AUTHC_SUCCESS.getMsgKey());
        UserProfilePayload profilePayload = this.getPayloadRepository().getProfilePayload((AbstractAuthenticationToken)authentication, this.isCheckExpiry());
        String body = JSONObject.toJSONString((Object)AuthResponse.success((String)message, (Object)profilePayload));
        DataBuffer buffer = response.bufferFactory().wrap(body.getBytes(StandardCharsets.UTF_8));
        return response.writeWith((Publisher)Mono.just((Object)buffer));
    }

    public JwtPayloadRepository getPayloadRepository() {
        return this.payloadRepository;
    }

    public void setPayloadRepository(JwtPayloadRepository payloadRepository) {
        this.payloadRepository = payloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }
}

