/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.http.HttpStatus;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.boot.biz.SpringSecurityBizMessageSource;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationSuccessHandler;
import org.springframework.security.boot.biz.exception.AuthResponse;
import org.springframework.security.boot.biz.exception.AuthResponseCode;
import org.springframework.security.boot.biz.userdetails.JwtPayloadRepository;
import org.springframework.security.boot.biz.userdetails.UserProfilePayload;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationToken;
import org.springframework.security.boot.utils.SubjectUtils;
import org.springframework.security.core.Authentication;

public class JwtMatchedAuthenticationSuccessHandler
implements MatchedAuthenticationSuccessHandler {
    protected MessageSourceAccessor messages = SpringSecurityBizMessageSource.getAccessor();
    private JwtPayloadRepository payloadRepository;
    private boolean checkExpiry = false;

    public JwtMatchedAuthenticationSuccessHandler(JwtPayloadRepository payloadRepository) {
        this.setPayloadRepository(payloadRepository);
    }

    public boolean supports(Authentication authentication) {
        return SubjectUtils.isAssignableFrom(authentication.getClass(), (Class[])new Class[]{JwtAuthenticationToken.class});
    }

    public void onAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        response.setStatus(HttpStatus.OK.value());
        response.setContentType("application/json");
        response.setCharacterEncoding(StandardCharsets.UTF_8.name());
        String message = this.messages.getMessage(AuthResponseCode.SC_AUTHC_SUCCESS.getMsgKey());
        UserProfilePayload profilePayload = this.getPayloadRepository().getProfilePayload((AbstractAuthenticationToken)authentication, this.isCheckExpiry());
        JSONObject.writeJSONString((Writer)response.getWriter(), (Object)AuthResponse.success((String)message, (Object)profilePayload), (SerializerFeature[])new SerializerFeature[0]);
    }

    public JwtPayloadRepository getPayloadRepository() {
        return this.payloadRepository;
    }

    public void setPayloadRepository(JwtPayloadRepository payloadRepository) {
        this.payloadRepository = payloadRepository;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }
}

