/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.boot.biz.authentication.AuthenticationProcessingFilter;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationToken;
import org.springframework.security.boot.jwt.exception.AuthenticationJwtNotFoundException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.session.NullAuthenticatedSessionStrategy;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class JwtAuthorizationProcessingFilter
extends AuthenticationProcessingFilter {
    public static final String AUTHORIZATION_PARAM = "token";
    public static final String AUTHORIZATION_HEADER = "X-Authorization";
    private String authorizationHeaderName = "X-Authorization";
    private String authorizationParamName = "token";
    private String authorizationCookieName = "token";
    private List<RequestMatcher> ignoreRequestMatchers;
    private SessionAuthenticationStrategy sessionStrategy = new NullAuthenticatedSessionStrategy();

    public JwtAuthorizationProcessingFilter() {
        super((RequestMatcher)new AntPathRequestMatcher("/**"));
    }

    public JwtAuthorizationProcessingFilter(List<String> ignorePatterns) {
        super((RequestMatcher)new AntPathRequestMatcher("/**"));
        this.setIgnoreRequestMatcher(ignorePatterns);
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        if (!CollectionUtils.isEmpty(this.ignoreRequestMatchers)) {
            for (RequestMatcher requestMatcher : this.ignoreRequestMatchers) {
                if (!requestMatcher.matches(request)) continue;
                return false;
            }
        }
        return super.requiresAuthentication(request, response);
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        Authentication authResult;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        ServletRequestAttributes requestAttributes = new ServletRequestAttributes(request, response);
        RequestContextHolder.setRequestAttributes((RequestAttributes)requestAttributes, (boolean)true);
        if (!this.requiresAuthentication(request, response)) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Request is to process authentication");
        }
        try {
            authResult = this.attemptAuthentication(request, response);
            if (authResult == null) {
                return;
            }
            this.sessionStrategy.onAuthentication(authResult, request, response);
        }
        catch (InternalAuthenticationServiceException failed) {
            logger.error("An internal error occurred while trying to authenticate the user.", (Throwable)failed);
            this.unsuccessfulAuthentication(request, response, (AuthenticationException)((Object)failed));
            return;
        }
        catch (AuthenticationException failed) {
            this.unsuccessfulAuthentication(request, response, failed);
            return;
        }
        this.successfulAuthentication(request, response, chain, authResult);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public void setSessionAuthenticationStrategy(SessionAuthenticationStrategy sessionStrategy) {
        super.setSessionAuthenticationStrategy(sessionStrategy);
        this.sessionStrategy = sessionStrategy;
    }

    public Authentication doAttemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException, IOException, ServletException {
        String token = this.obtainToken(request);
        if (token == null) {
            token = "";
        }
        if (StringUtils.isBlank((CharSequence)(token = token.trim()))) {
            throw new AuthenticationJwtNotFoundException("JWT not provided");
        }
        JwtAuthorizationToken authRequest = new JwtAuthorizationToken(this.obtainUid(request), token);
        authRequest.setLongitude(this.obtainLongitude(request));
        authRequest.setLatitude(this.obtainLatitude(request));
        authRequest.setSign(this.obtainSign(request));
        this.setDetails(request, authRequest);
        return this.getAuthenticationManager().authenticate((Authentication)authRequest);
    }

    protected void setDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        authRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
    }

    protected String obtainToken(HttpServletRequest request) {
        String token = request.getHeader(this.getAuthorizationHeaderName());
        if (StringUtils.isEmpty((CharSequence)token)) {
            return request.getParameter(this.getAuthorizationParamName());
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            Cookie[] cookies = request.getCookies();
            if (null == cookies || cookies.length == 0) {
                return null;
            }
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(this.getAuthorizationCookieName())) continue;
                token = cookie.getValue();
                break;
            }
        }
        return token;
    }

    public void setIgnoreRequestMatcher(List<String> ignorePatterns) {
        if (!CollectionUtils.isEmpty(ignorePatterns)) {
            this.ignoreRequestMatchers = ignorePatterns.stream().map(pattern -> new AntPathRequestMatcher(pattern)).collect(Collectors.toList());
        }
    }

    public void setIgnoreRequestMatchers(RequestMatcher ... ignoreRequestMatchers) {
        this.ignoreRequestMatchers = Arrays.asList(ignoreRequestMatchers);
    }

    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    public String getAuthorizationParamName() {
        return this.authorizationParamName;
    }

    public void setAuthorizationParamName(String authorizationParamName) {
        this.authorizationParamName = authorizationParamName;
    }

    public String getAuthorizationCookieName() {
        return this.authorizationCookieName;
    }

    public void setAuthorizationCookieName(String authorizationCookieName) {
        this.authorizationCookieName = authorizationCookieName;
    }
}

