/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.security.authentication.AccountStatusUserDetailsChecker;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.boot.biz.userdetails.SecurityPrincipal;
import org.springframework.security.boot.biz.userdetails.UserDetailsServiceAdapter;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.SpringSecurityMessageSource;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class JwtAuthenticationProvider
implements AuthenticationProvider {
    protected MessageSourceAccessor messages = SpringSecurityMessageSource.getAccessor();
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final PasswordEncoder passwordEncoder;
    private final UserDetailsServiceAdapter userDetailsService;
    private UserDetailsChecker userDetailsChecker = new AccountStatusUserDetailsChecker();

    public JwtAuthenticationProvider(UserDetailsServiceAdapter userDetailsService, PasswordEncoder passwordEncoder) {
        this.userDetailsService = userDetailsService;
        this.passwordEncoder = passwordEncoder;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Assert.notNull((Object)authentication, (String)"No authentication data provided");
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Processing authentication request : " + authentication);
        }
        JwtAuthenticationToken jwtToken = (JwtAuthenticationToken)authentication;
        String username = (String)authentication.getPrincipal();
        String password = (String)authentication.getCredentials();
        if (!StringUtils.hasLength((String)username)) {
            this.logger.debug("No principal found in request.");
            throw new BadCredentialsException("No principal found in request.");
        }
        if (!StringUtils.hasLength((String)password)) {
            this.logger.debug("No credentials found in request.");
            throw new BadCredentialsException("No credentials found in request.");
        }
        UserDetails ud = this.getUserDetailsService().loadUserDetails(authentication);
        if (!this.passwordEncoder.matches((CharSequence)password, ud.getPassword())) {
            throw new BadCredentialsException("Authentication Failed. Username or Password not valid.");
        }
        this.getUserDetailsChecker().check(ud);
        JwtAuthenticationToken authenticationToken = null;
        if (SecurityPrincipal.class.isAssignableFrom(ud.getClass())) {
            SecurityPrincipal principal = (SecurityPrincipal)ud;
            principal.setSign(jwtToken.getSign());
            principal.setLongitude(jwtToken.getLongitude());
            principal.setLatitude(jwtToken.getLatitude());
            authenticationToken = new JwtAuthenticationToken(ud, ud.getPassword(), ud.getAuthorities());
        } else {
            authenticationToken = new JwtAuthenticationToken(ud.getUsername(), ud.getPassword(), ud.getAuthorities());
        }
        authenticationToken.setDetails(authentication.getDetails());
        return authenticationToken;
    }

    public boolean supports(Class<?> authentication) {
        return JwtAuthenticationToken.class.isAssignableFrom(authentication);
    }

    public void setUserDetailsChecker(UserDetailsChecker userDetailsChecker) {
        this.userDetailsChecker = userDetailsChecker;
    }

    public UserDetailsChecker getUserDetailsChecker() {
        return this.userDetailsChecker;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public UserDetailsServiceAdapter getUserDetailsService() {
        return this.userDetailsService;
    }
}

