/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot.jwt.authentication;

import com.fasterxml.jackson.databind.ObjectMapper;
import javax.servlet.http.HttpServletRequest;
import org.springframework.security.authentication.AbstractAuthenticationToken;
import org.springframework.security.boot.biz.authentication.PostRequestAuthenticationProcessingFilter;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationToken;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;

public class JwtAuthenticationProcessingFilter
extends PostRequestAuthenticationProcessingFilter {
    public JwtAuthenticationProcessingFilter(ObjectMapper objectMapper) {
        super(objectMapper, new AntPathRequestMatcher("/login/jwt", "POST"));
    }

    protected void setDetails(HttpServletRequest request, AbstractAuthenticationToken authRequest) {
        super.setDetails(request, authRequest);
        JwtAuthenticationToken jwtToken = (JwtAuthenticationToken)authRequest;
        jwtToken.setLongitude(this.obtainLongitude(request));
        jwtToken.setLatitude(this.obtainLatitude(request));
        jwtToken.setSign(this.obtainSign(request));
    }

    protected AbstractAuthenticationToken authenticationToken(String username, String password) {
        return new JwtAuthenticationToken(username, password);
    }
}

