/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot;

import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.security.boot.biz.property.SecurityHeaderCorsProperties;
import org.springframework.security.boot.biz.property.SecurityHeaderCsrfProperties;
import org.springframework.security.boot.biz.property.SecurityHeadersProperties;

@ConfigurationProperties(prefix="spring.security.jwt.authz")
public class SecurityJwtAuthzProperties {
    public static final String PREFIX = "spring.security.jwt.authz";
    private boolean enabled = false;
    private boolean checkExpiry = false;
    private boolean checkPrincipal = false;
    private String pathPattern = "/**";
    private String[] ignorePatterns = new String[]{"/login/jwt"};
    private String authorizationHeaderName = "X-Authorization";
    private String authorizationParamName = "token";
    private String authorizationCookieName = "token";
    private boolean continueChainBeforeSuccessfulAuthentication = true;
    @NestedConfigurationProperty
    private SecurityHeadersProperties headers = new SecurityHeadersProperties();
    @NestedConfigurationProperty
    private SecurityHeaderCorsProperties cros = new SecurityHeaderCorsProperties();
    @NestedConfigurationProperty
    private SecurityHeaderCsrfProperties csrf = new SecurityHeaderCsrfProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isCheckExpiry() {
        return this.checkExpiry;
    }

    public boolean isCheckPrincipal() {
        return this.checkPrincipal;
    }

    public String getPathPattern() {
        return this.pathPattern;
    }

    public String[] getIgnorePatterns() {
        return this.ignorePatterns;
    }

    public String getAuthorizationHeaderName() {
        return this.authorizationHeaderName;
    }

    public String getAuthorizationParamName() {
        return this.authorizationParamName;
    }

    public String getAuthorizationCookieName() {
        return this.authorizationCookieName;
    }

    public boolean isContinueChainBeforeSuccessfulAuthentication() {
        return this.continueChainBeforeSuccessfulAuthentication;
    }

    public SecurityHeadersProperties getHeaders() {
        return this.headers;
    }

    public SecurityHeaderCorsProperties getCros() {
        return this.cros;
    }

    public SecurityHeaderCsrfProperties getCsrf() {
        return this.csrf;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCheckExpiry(boolean checkExpiry) {
        this.checkExpiry = checkExpiry;
    }

    public void setCheckPrincipal(boolean checkPrincipal) {
        this.checkPrincipal = checkPrincipal;
    }

    public void setPathPattern(String pathPattern) {
        this.pathPattern = pathPattern;
    }

    public void setIgnorePatterns(String[] ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    public void setAuthorizationHeaderName(String authorizationHeaderName) {
        this.authorizationHeaderName = authorizationHeaderName;
    }

    public void setAuthorizationParamName(String authorizationParamName) {
        this.authorizationParamName = authorizationParamName;
    }

    public void setAuthorizationCookieName(String authorizationCookieName) {
        this.authorizationCookieName = authorizationCookieName;
    }

    public void setContinueChainBeforeSuccessfulAuthentication(boolean continueChainBeforeSuccessfulAuthentication) {
        this.continueChainBeforeSuccessfulAuthentication = continueChainBeforeSuccessfulAuthentication;
    }

    public void setHeaders(SecurityHeadersProperties headers) {
        this.headers = headers;
    }

    public void setCros(SecurityHeaderCorsProperties cros) {
        this.cros = cros;
    }

    public void setCsrf(SecurityHeaderCsrfProperties csrf) {
        this.csrf = csrf;
    }

    public String toString() {
        return "SecurityJwtAuthzProperties(enabled=" + this.isEnabled() + ", checkExpiry=" + this.isCheckExpiry() + ", checkPrincipal=" + this.isCheckPrincipal() + ", pathPattern=" + this.getPathPattern() + ", ignorePatterns=" + Arrays.deepToString(this.getIgnorePatterns()) + ", authorizationHeaderName=" + this.getAuthorizationHeaderName() + ", authorizationParamName=" + this.getAuthorizationParamName() + ", authorizationCookieName=" + this.getAuthorizationCookieName() + ", continueChainBeforeSuccessfulAuthentication=" + this.isContinueChainBeforeSuccessfulAuthentication() + ", headers=" + this.getHeaders() + ", cros=" + this.getCros() + ", csrf=" + this.getCsrf() + ")";
    }
}

