/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.biz.web.servlet.i18n.LocaleContextFilter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.boot.SecurityBizProperties;
import org.springframework.security.boot.SecurityJwtAuthcProperties;
import org.springframework.security.boot.SecurityJwtAuthzProperties;
import org.springframework.security.boot.WebSecurityBizConfigurerAdapter;
import org.springframework.security.boot.biz.JsonInvalidSessionStrategy;
import org.springframework.security.boot.biz.authentication.AuthenticatingFailureCounter;
import org.springframework.security.boot.biz.authentication.AuthenticationListener;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationEntryPoint;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationFailureHandler;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationSuccessHandler;
import org.springframework.security.boot.biz.property.SecurityAuthcProperties;
import org.springframework.security.boot.biz.property.SecuritySessionMgtProperties;
import org.springframework.security.boot.biz.userdetails.JwtPayloadRepository;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationProcessingFilter;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationProvider;
import org.springframework.security.boot.jwt.authentication.JwtAuthorizationSuccessHandler;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;
import org.springframework.util.CollectionUtils;

@Configuration
@AutoConfigureBefore(value={SecurityFilterAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(prefix="spring.security.jwt.authz", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SecurityBizProperties.class, SecurityJwtAuthcProperties.class, SecurityJwtAuthzProperties.class})
public class SecurityJwtAuthzFilterConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JwtAuthorizationProvider jwtAuthorizationProvider(JwtPayloadRepository payloadRepository, SecurityJwtAuthzProperties jwtAuthzProperties) {
        JwtAuthorizationProvider jwtAuthorizationProvider = new JwtAuthorizationProvider(payloadRepository);
        jwtAuthorizationProvider.setCheckExpiry(jwtAuthzProperties.isCheckExpiry());
        jwtAuthorizationProvider.setCheckPrincipal(jwtAuthzProperties.isCheckPrincipal());
        return jwtAuthorizationProvider;
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.security.jwt.authz", value={"enabled"}, havingValue="true")
    @EnableConfigurationProperties(value={SecurityBizProperties.class, SecurityJwtAuthcProperties.class, SecurityJwtAuthzProperties.class})
    @Order(value=-20)
    static class JwtAuthzWebSecurityConfigurerAdapter
    extends WebSecurityBizConfigurerAdapter {
        private final SecurityBizProperties bizProperties;
        private final SecurityJwtAuthcProperties authcProperties;
        private final SecurityJwtAuthzProperties authzProperties;
        private final LocaleContextFilter localeContextFilter;
        private final AuthenticationEntryPoint authenticationEntryPoint;
        private final AuthenticationSuccessHandler authenticationSuccessHandler;
        private final AuthenticationFailureHandler authenticationFailureHandler;
        private final InvalidSessionStrategy invalidSessionStrategy;
        private final RequestCache requestCache;
        private final RememberMeServices rememberMeServices;
        private final SessionRegistry sessionRegistry;
        private final SessionAuthenticationStrategy sessionAuthenticationStrategy;
        private final SessionInformationExpiredStrategy sessionInformationExpiredStrategy;

        public JwtAuthzWebSecurityConfigurerAdapter(SecurityBizProperties bizProperties, SecurityJwtAuthcProperties authcProperties, SecurityJwtAuthzProperties authzProperties, ObjectProvider<LocaleContextFilter> localeContextProvider, ObjectProvider<AuthenticationProvider> authenticationProvider, ObjectProvider<AuthenticationManager> authenticationManagerProvider, ObjectProvider<AuthenticationListener> authenticationListenerProvider, ObjectProvider<AuthenticatingFailureCounter> authenticatingFailureCounter, ObjectProvider<MatchedAuthenticationEntryPoint> authenticationEntryPointProvider, ObjectProvider<MatchedAuthenticationSuccessHandler> authenticationSuccessHandlerProvider, ObjectProvider<MatchedAuthenticationFailureHandler> authenticationFailureHandlerProvider, ObjectProvider<RequestCache> requestCacheProvider, ObjectProvider<RememberMeServices> rememberMeServicesProvider, ObjectProvider<SessionRegistry> sessionRegistryProvider, ObjectProvider<SessionAuthenticationStrategy> sessionAuthenticationStrategyProvider, ObjectProvider<SessionInformationExpiredStrategy> sessionInformationExpiredStrategyProvider) {
            super(bizProperties, (SecurityAuthcProperties)authcProperties, authenticationProvider.stream().collect(Collectors.toList()), (AuthenticationManager)authenticationManagerProvider.getIfAvailable());
            this.bizProperties = bizProperties;
            this.authcProperties = authcProperties;
            this.authzProperties = authzProperties;
            this.localeContextFilter = (LocaleContextFilter)localeContextProvider.getIfAvailable();
            List authenticationListeners = authenticationListenerProvider.stream().collect(Collectors.toList());
            this.authenticationEntryPoint = super.authenticationEntryPoint(authenticationEntryPointProvider.stream().collect(Collectors.toList()));
            this.authenticationSuccessHandler = new JwtAuthorizationSuccessHandler();
            this.authenticationFailureHandler = super.authenticationFailureHandler(authenticationListeners, authenticationFailureHandlerProvider.stream().collect(Collectors.toList()));
            this.invalidSessionStrategy = new JsonInvalidSessionStrategy();
            this.requestCache = super.requestCache();
            this.rememberMeServices = super.rememberMeServices();
            this.sessionRegistry = super.sessionRegistry();
            this.sessionAuthenticationStrategy = super.sessionAuthenticationStrategy();
            this.sessionInformationExpiredStrategy = super.sessionInformationExpiredStrategy();
        }

        public JwtAuthorizationProcessingFilter authenticationProcessingFilter() throws Exception {
            JwtAuthorizationProcessingFilter authenticationFilter = new JwtAuthorizationProcessingFilter();
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)this.authcProperties.getSessionMgt().isAllowSessionCreation()).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setAllowSessionCreation(arg_0));
            map.from((Object)this.authenticationManagerBean()).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setAuthenticationManager(arg_0));
            map.from((Object)this.authenticationSuccessHandler).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setAuthenticationSuccessHandler(arg_0));
            map.from((Object)this.authenticationFailureHandler).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setAuthenticationFailureHandler(arg_0));
            map.from((Object)this.authzProperties.getAuthorizationCookieName()).to(authenticationFilter::setAuthorizationCookieName);
            map.from((Object)this.authzProperties.getAuthorizationHeaderName()).to(authenticationFilter::setAuthorizationHeaderName);
            map.from((Object)this.authzProperties.getAuthorizationParamName()).to(authenticationFilter::setAuthorizationParamName);
            map.from((Object)this.authzProperties.getPathPattern()).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setFilterProcessesUrl(arg_0));
            map.from((Object)this.rememberMeServices).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setRememberMeServices(arg_0));
            map.from((Object)this.sessionAuthenticationStrategy).to(authenticationFilter::setSessionAuthenticationStrategy);
            map.from((Object)this.authzProperties.isContinueChainBeforeSuccessfulAuthentication()).to(arg_0 -> ((JwtAuthorizationProcessingFilter)authenticationFilter).setContinueChainBeforeSuccessfulAuthentication(arg_0));
            List noneEntries = this.bizProperties.getFilterChainDefinitionMap().entrySet().stream().filter(predicate -> "anon".equalsIgnoreCase((String)predicate.getValue())).collect(Collectors.toList());
            ArrayList<String> ignorePatterns = new ArrayList<String>();
            if (!CollectionUtils.isEmpty(noneEntries)) {
                ignorePatterns = noneEntries.stream().map(mapper -> (String)mapper.getKey()).collect(Collectors.toList());
            }
            ignorePatterns.add(this.authcProperties.getPathPattern());
            authenticationFilter.setIgnoreRequestMatcher(ignorePatterns);
            return authenticationFilter;
        }

        public void configure(HttpSecurity http) throws Exception {
            SecuritySessionMgtProperties sessionMgt = this.authcProperties.getSessionMgt();
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().enableSessionUrlRewriting(sessionMgt.isEnableSessionUrlRewriting()).invalidSessionStrategy(this.invalidSessionStrategy).maximumSessions(sessionMgt.getMaximumSessions().intValue()).maxSessionsPreventsLogin(sessionMgt.isMaxSessionsPreventsLogin()).expiredSessionStrategy(this.sessionInformationExpiredStrategy).sessionRegistry(this.sessionRegistry).and().sessionAuthenticationErrorUrl(sessionMgt.getFailureUrl()).sessionAuthenticationFailureHandler(this.authenticationFailureHandler).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy).sessionCreationPolicy(sessionMgt.getCreationPolicy()).and()).requestCache().requestCache(this.requestCache).and()).exceptionHandling().authenticationEntryPoint(this.authenticationEntryPoint).and()).httpBasic().authenticationEntryPoint(this.authenticationEntryPoint).and()).antMatcher(this.authzProperties.getPathPattern()).addFilterBefore((Filter)this.localeContextFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.authenticationProcessingFilter(), UsernamePasswordAuthenticationFilter.class);
            super.configure(http, this.authzProperties.getCros());
            super.configure(http, this.authzProperties.getCsrf());
            super.configure(http, this.authzProperties.getHeaders());
            super.configure(http);
        }

        public void configure(WebSecurity web) throws Exception {
            super.configure(web);
        }
    }
}

