/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.security.boot.biz.property.SecurityAuthcProperties;
import org.springframework.security.boot.biz.property.SecurityCaptchaProperties;
import org.springframework.security.boot.biz.property.SecurityHeaderCsrfProperties;
import org.springframework.security.boot.biz.property.SecurityLogoutProperties;

@ConfigurationProperties(prefix="spring.security.jwt.authc")
public class SecurityJwtAuthcProperties
extends SecurityAuthcProperties {
    public static final String PREFIX = "spring.security.jwt.authc";
    private boolean enabled = false;
    private String usernameParameter = "username";
    private String passwordParameter = "password";
    @NestedConfigurationProperty
    private SecurityCaptchaProperties captcha = new SecurityCaptchaProperties();
    @NestedConfigurationProperty
    private SecurityHeaderCsrfProperties csrf = new SecurityHeaderCsrfProperties();
    @NestedConfigurationProperty
    private SecurityLogoutProperties logout = new SecurityLogoutProperties();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getUsernameParameter() {
        return this.usernameParameter;
    }

    public String getPasswordParameter() {
        return this.passwordParameter;
    }

    public SecurityCaptchaProperties getCaptcha() {
        return this.captcha;
    }

    public SecurityHeaderCsrfProperties getCsrf() {
        return this.csrf;
    }

    public SecurityLogoutProperties getLogout() {
        return this.logout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setUsernameParameter(String usernameParameter) {
        this.usernameParameter = usernameParameter;
    }

    public void setPasswordParameter(String passwordParameter) {
        this.passwordParameter = passwordParameter;
    }

    public void setCaptcha(SecurityCaptchaProperties captcha) {
        this.captcha = captcha;
    }

    public void setCsrf(SecurityHeaderCsrfProperties csrf) {
        this.csrf = csrf;
    }

    public void setLogout(SecurityLogoutProperties logout) {
        this.logout = logout;
    }

    public String toString() {
        return "SecurityJwtAuthcProperties(enabled=" + this.isEnabled() + ", usernameParameter=" + this.getUsernameParameter() + ", passwordParameter=" + this.getPasswordParameter() + ", captcha=" + this.getCaptcha() + ", csrf=" + this.getCsrf() + ", logout=" + this.getLogout() + ")";
    }
}

