/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.Filter;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.biz.web.servlet.i18n.LocaleContextFilter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.servlet.SecurityFilterAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.boot.SecurityBizProperties;
import org.springframework.security.boot.SecurityJwtAuthcProperties;
import org.springframework.security.boot.WebSecurityBizConfigurerAdapter;
import org.springframework.security.boot.biz.authentication.AuthenticatingFailureCounter;
import org.springframework.security.boot.biz.authentication.AuthenticationListener;
import org.springframework.security.boot.biz.authentication.captcha.CaptchaResolver;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationEntryPoint;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationFailureHandler;
import org.springframework.security.boot.biz.authentication.nested.MatchedAuthenticationSuccessHandler;
import org.springframework.security.boot.biz.property.SecurityAuthcProperties;
import org.springframework.security.boot.biz.property.SecurityLogoutProperties;
import org.springframework.security.boot.biz.property.SecuritySessionMgtProperties;
import org.springframework.security.boot.biz.userdetails.UserDetailsServiceAdapter;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationProcessingFilter;
import org.springframework.security.boot.jwt.authentication.JwtAuthenticationProvider;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.core.session.SessionRegistry;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;
import org.springframework.security.web.authentication.logout.LogoutHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.security.web.authentication.session.SessionAuthenticationStrategy;
import org.springframework.security.web.csrf.CsrfTokenRepository;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.session.InvalidSessionStrategy;
import org.springframework.security.web.session.SessionInformationExpiredStrategy;

@Configuration
@AutoConfigureBefore(value={SecurityFilterAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnProperty(prefix="spring.security.jwt.authc", value={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SecurityBizProperties.class, SecurityJwtAuthcProperties.class})
public class SecurityJwtAuthcFilterConfiguration {
    @Bean
    public JwtAuthenticationProvider jwtAuthenticationProvider(UserDetailsServiceAdapter userDetailsService, PasswordEncoder passwordEncoder) {
        return new JwtAuthenticationProvider(userDetailsService, passwordEncoder);
    }

    @Configuration
    @ConditionalOnProperty(prefix="spring.security.jwt.authc", value={"enabled"}, havingValue="true")
    @EnableConfigurationProperties(value={SecurityBizProperties.class, SecurityJwtAuthcProperties.class})
    @Order(value=-91)
    static class JwtAuthcWebSecurityConfigurerAdapter
    extends WebSecurityBizConfigurerAdapter {
        private final SecurityJwtAuthcProperties authcProperties;
        private final LocaleContextFilter localeContextFilter;
        private final AuthenticatingFailureCounter authenticatingFailureCounter;
        private final AuthenticationEntryPoint authenticationEntryPoint;
        private final AuthenticationSuccessHandler authenticationSuccessHandler;
        private final AuthenticationFailureHandler authenticationFailureHandler;
        private final CaptchaResolver captchaResolver;
        private final InvalidSessionStrategy invalidSessionStrategy;
        private final LogoutSuccessHandler logoutSuccessHandler;
        private final LogoutHandler logoutHandler;
        private final ObjectMapper objectMapper;
        private final RequestCache requestCache;
        private final RememberMeServices rememberMeServices;
        private final SessionRegistry sessionRegistry;
        private final SessionAuthenticationStrategy sessionAuthenticationStrategy;
        private final SessionInformationExpiredStrategy sessionInformationExpiredStrategy;

        public JwtAuthcWebSecurityConfigurerAdapter(SecurityBizProperties bizProperties, SecurityJwtAuthcProperties authcProperties, ObjectProvider<LocaleContextFilter> localeContextProvider, ObjectProvider<AuthenticationProvider> authenticationProvider, ObjectProvider<AuthenticationManager> authenticationManagerProvider, ObjectProvider<AuthenticationListener> authenticationListenerProvider, ObjectProvider<AuthenticatingFailureCounter> authenticatingFailureCounter, ObjectProvider<MatchedAuthenticationEntryPoint> authenticationEntryPointProvider, ObjectProvider<MatchedAuthenticationSuccessHandler> authenticationSuccessHandlerProvider, ObjectProvider<MatchedAuthenticationFailureHandler> authenticationFailureHandlerProvider, ObjectProvider<CaptchaResolver> captchaResolverProvider, ObjectProvider<CsrfTokenRepository> csrfTokenRepositoryProvider, ObjectProvider<InvalidSessionStrategy> invalidSessionStrategyProvider, @Qualifier(value="jwtLogoutSuccessHandler") ObjectProvider<LogoutSuccessHandler> logoutSuccessHandlerProvider, ObjectProvider<LogoutHandler> logoutHandlerProvider, ObjectProvider<ObjectMapper> objectMapperProvider) {
            super(bizProperties, (SecurityAuthcProperties)authcProperties, authenticationProvider.stream().collect(Collectors.toList()), (AuthenticationManager)authenticationManagerProvider.getIfAvailable());
            this.authcProperties = authcProperties;
            this.localeContextFilter = (LocaleContextFilter)localeContextProvider.getIfAvailable();
            this.authenticatingFailureCounter = super.authenticatingFailureCounter();
            List authenticationListeners = authenticationListenerProvider.stream().collect(Collectors.toList());
            this.authenticationEntryPoint = super.authenticationEntryPoint(authenticationEntryPointProvider.stream().collect(Collectors.toList()));
            this.authenticationSuccessHandler = super.authenticationSuccessHandler(authenticationListeners, authenticationSuccessHandlerProvider.stream().collect(Collectors.toList()));
            this.authenticationFailureHandler = super.authenticationFailureHandler(authenticationListeners, authenticationFailureHandlerProvider.stream().collect(Collectors.toList()));
            this.captchaResolver = (CaptchaResolver)captchaResolverProvider.getIfAvailable();
            this.invalidSessionStrategy = super.invalidSessionStrategy();
            this.logoutSuccessHandler = super.logoutSuccessHandler();
            this.logoutHandler = super.logoutHandler(logoutHandlerProvider.stream().collect(Collectors.toList()));
            this.objectMapper = (ObjectMapper)objectMapperProvider.getIfAvailable();
            this.requestCache = super.requestCache();
            this.rememberMeServices = super.rememberMeServices();
            this.sessionRegistry = super.sessionRegistry();
            this.sessionAuthenticationStrategy = super.sessionAuthenticationStrategy();
            this.sessionInformationExpiredStrategy = super.sessionInformationExpiredStrategy();
        }

        public JwtAuthenticationProcessingFilter authenticationProcessingFilter() throws Exception {
            JwtAuthenticationProcessingFilter authenticationFilter = new JwtAuthenticationProcessingFilter(this.objectMapper);
            PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
            map.from((Object)this.authcProperties.getSessionMgt().isAllowSessionCreation()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setAllowSessionCreation(arg_0));
            map.from((Object)this.authenticationManagerBean()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setAuthenticationManager(arg_0));
            map.from((Object)this.authenticationSuccessHandler).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setAuthenticationSuccessHandler(arg_0));
            map.from((Object)this.authenticationFailureHandler).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setAuthenticationFailureHandler(arg_0));
            map.from((Object)this.authcProperties.getPathPattern()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setFilterProcessesUrl(arg_0));
            map.from((Object)this.authcProperties.getCaptcha().getParamName()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setCaptchaParameter(arg_0));
            map.from((Object)this.authcProperties.getCaptcha().isRequired()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setCaptchaRequired(arg_0));
            map.from((Object)this.captchaResolver).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setCaptchaResolver(arg_0));
            map.from((Object)this.authenticatingFailureCounter).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setFailureCounter(arg_0));
            map.from((Object)this.authcProperties.getUsernameParameter()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setUsernameParameter(arg_0));
            map.from((Object)this.authcProperties.getPasswordParameter()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setPasswordParameter(arg_0));
            map.from((Object)this.authcProperties.isPostOnly()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setPostOnly(arg_0));
            map.from((Object)this.authcProperties.getRetry().getRetryTimesKeyAttribute()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setRetryTimesKeyAttribute(arg_0));
            map.from((Object)this.authcProperties.getRetry().getRetryTimesWhenAccessDenied()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setRetryTimesWhenAccessDenied(arg_0));
            map.from((Object)this.rememberMeServices).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setRememberMeServices(arg_0));
            map.from((Object)this.sessionAuthenticationStrategy).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setSessionAuthenticationStrategy(arg_0));
            map.from((Object)this.authcProperties.isContinueChainBeforeSuccessfulAuthentication()).to(arg_0 -> ((JwtAuthenticationProcessingFilter)authenticationFilter).setContinueChainBeforeSuccessfulAuthentication(arg_0));
            return authenticationFilter;
        }

        public void configure(HttpSecurity http) throws Exception {
            SecuritySessionMgtProperties sessionMgt = this.authcProperties.getSessionMgt();
            SecurityLogoutProperties logout = this.authcProperties.getLogout();
            ((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.sessionManagement().enableSessionUrlRewriting(sessionMgt.isEnableSessionUrlRewriting()).invalidSessionStrategy(this.invalidSessionStrategy).invalidSessionUrl(logout.getLogoutUrl()).maximumSessions(sessionMgt.getMaximumSessions().intValue()).maxSessionsPreventsLogin(sessionMgt.isMaxSessionsPreventsLogin()).expiredSessionStrategy(this.sessionInformationExpiredStrategy).expiredUrl(logout.getLogoutUrl()).sessionRegistry(this.sessionRegistry).and().sessionAuthenticationErrorUrl(sessionMgt.getFailureUrl()).sessionAuthenticationFailureHandler(this.authenticationFailureHandler).sessionAuthenticationStrategy(this.sessionAuthenticationStrategy).sessionCreationPolicy(sessionMgt.getCreationPolicy()).and()).logout().logoutUrl(logout.getPathPatterns()).logoutSuccessHandler(this.logoutSuccessHandler).addLogoutHandler(this.logoutHandler).clearAuthentication(logout.isClearAuthentication()).invalidateHttpSession(logout.isInvalidateHttpSession()).and()).requestCache().requestCache(this.requestCache).and()).exceptionHandling().authenticationEntryPoint(this.authenticationEntryPoint).and()).httpBasic().disable()).antMatcher(this.authcProperties.getPathPattern()).addFilterBefore((Filter)this.localeContextFilter, UsernamePasswordAuthenticationFilter.class).addFilterBefore((Filter)this.authenticationProcessingFilter(), UsernamePasswordAuthenticationFilter.class);
            super.configure(http, this.authcProperties.getCors());
            super.configure(http, this.authcProperties.getCsrf());
            super.configure(http, this.authcProperties.getHeaders());
            super.configure(http);
        }

        public void configure(WebSecurity web) throws Exception {
            super.configure(web);
        }
    }
}

