/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.boot;

import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.security.reactive.ReactiveSecurityAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.ReactiveAuthenticationManager;
import org.springframework.security.boot.SecurityBizProperties;
import org.springframework.security.boot.SecurityJwtAuthcProperties;
import org.springframework.security.boot.SecurityJwtAuthzProperties;
import org.springframework.security.boot.biz.userdetails.JwtPayloadRepository;
import org.springframework.security.boot.jwt.authentication.server.JwtMatchedServerAuthenticationEntryPoint;
import org.springframework.security.boot.jwt.authentication.server.JwtMatchedServerAuthenticationFailureHandler;
import org.springframework.security.boot.jwt.authentication.server.JwtMatchedServerAuthenticationSuccessHandler;
import org.springframework.security.boot.jwt.authentication.server.JwtReactiveAuthenticationManager;
import org.springframework.security.boot.jwt.authentication.server.JwtServerAuthenticationConverter;
import org.springframework.security.boot.jwt.authentication.server.JwtServerAuthorizationSecurityContextRepository;
import org.springframework.security.web.server.authentication.ServerAuthenticationConverter;
import org.springframework.security.web.server.context.ServerSecurityContextRepository;

@Configuration
@AutoConfigureBefore(value={ReactiveSecurityAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.REACTIVE)
@EnableConfigurationProperties(value={SecurityBizProperties.class, SecurityJwtAuthcProperties.class, SecurityJwtAuthzProperties.class})
public class ReactiveSecurityJwtAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public JwtMatchedServerAuthenticationEntryPoint jwtMatchedServerAuthenticationEntryPoint() {
        return new JwtMatchedServerAuthenticationEntryPoint();
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtMatchedServerAuthenticationFailureHandler jwtMatchedServerAuthenticationFailureHandler() {
        return new JwtMatchedServerAuthenticationFailureHandler();
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtMatchedServerAuthenticationSuccessHandler jwtMatchedServerAuthenticationSuccessHandler(JwtPayloadRepository payloadRepository) {
        return new JwtMatchedServerAuthenticationSuccessHandler(payloadRepository, true);
    }

    @Bean
    @ConditionalOnMissingBean
    public JwtPayloadRepository payloadRepository() {
        return new JwtPayloadRepository(){};
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerSecurityContextRepository jwtServerSecurityContextRepository(ReactiveAuthenticationManager authenticationManager) {
        return new JwtServerAuthorizationSecurityContextRepository(authenticationManager, "/webjars/**");
    }

    @Bean
    @ConditionalOnMissingBean
    public ServerAuthenticationConverter jwtServerAuthenticationConverter() {
        return new JwtServerAuthenticationConverter();
    }

    @Bean
    @ConditionalOnMissingBean
    public ReactiveAuthenticationManager jwtReactiveAuthenticationManager(JwtPayloadRepository payloadRepository, SecurityJwtAuthzProperties jwtAuthzProperties) {
        JwtReactiveAuthenticationManager jwtAuthenticationManager = new JwtReactiveAuthenticationManager(payloadRepository);
        jwtAuthenticationManager.setCheckExpiry(jwtAuthzProperties.isCheckExpiry());
        jwtAuthenticationManager.setCheckPrincipal(jwtAuthzProperties.isCheckPrincipal());
        return jwtAuthenticationManager;
    }
}

