/*
 * Decompiled with CFR 0.152.
 */
package com.annotatedsql.processor.sql;

import com.annotatedsql.AnnotationParsingException;
import com.annotatedsql.ParserEnv;
import com.annotatedsql.annotation.sql.From;
import com.annotatedsql.annotation.sql.Join;
import com.annotatedsql.annotation.sql.RawJoin;
import com.annotatedsql.annotation.sql.RawQuery;
import com.annotatedsql.annotation.sql.SqlQuery;
import com.annotatedsql.ftl.ViewMeta;
import com.annotatedsql.processor.sql.SimpleViewParser;
import com.annotatedsql.processor.sql.view.FromParser;
import com.annotatedsql.processor.sql.view.JoinParser;
import com.annotatedsql.processor.sql.view.RawJoinParser;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;

public class RawQueryParser
extends SimpleViewParser {
    public RawQueryParser(Element c, ParserEnv parserEnv) {
        super(c, parserEnv);
    }

    @Override
    public ViewMeta parse() {
        RawQuery q = this.f.getAnnotation(RawQuery.class);
        String name = q.value();
        if (this.parserEnv.containsTable(name)) {
            throw new AnnotationParsingException(String.format("Table/View/Query with name '%s' alredy defined", name), this.f);
        }
        this.viewMeta = new ViewMeta(this.f.getSimpleName().toString(), name);
        List<? extends Element> fields = this.f.getEnclosedElements();
        this.select = new StringBuilder(fields.size() * 32);
        this.sql = new StringBuilder(fields.size() * 32);
        this.sql.append("SELECT ");
        int pos = this.sql.length();
        From from = null;
        SqlQuery sqlQuery = null;
        for (Element element : fields) {
            RawJoin rawJoin;
            sqlQuery = element.getAnnotation(SqlQuery.class);
            if (sqlQuery != null) {
                this.sql.setLength(0);
                String sqlText = (String)((VariableElement)element).getConstantValue();
                this.sql.append(sqlText);
                break;
            }
            From tmpFrom = element.getAnnotation(From.class);
            if (tmpFrom != null) {
                if (from != null) {
                    throw new AnnotationParsingException("Dublicate @From annotation", element);
                }
                this.handleFromResult(new FromParser(this.parserEnv, this, element).parse(), true, pos);
                from = tmpFrom;
                continue;
            }
            Join join = element.getAnnotation(Join.class);
            if (join != null) {
                this.handleFromResult(new JoinParser(this.parserEnv, this, element).parse(), false, pos);
            }
            if ((rawJoin = element.getAnnotation(RawJoin.class)) == null) continue;
            if (join != null) {
                throw new AnnotationParsingException("element can have only one join", element);
            }
            this.handleFromResult(new RawJoinParser(this.parserEnv, this, element).parse(), false, pos);
        }
        if (from == null && sqlQuery == null) {
            throw new AnnotationParsingException("Query doesn't have @From/@SqlQuery annotation", this.f);
        }
        if (sqlQuery == null) {
            this.sql.insert(pos, this.select.toString());
        }
        this.viewMeta.setSql(this.sql.toString());
        this.addColumns2Env();
        return this.viewMeta;
    }
}

