/*******************************************************************************
 * (C) Copyright 2015 Haifeng Li
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/

package smile

/** A wavelet is a wave-like oscillation with an amplitude that starts out at
  * zero, increases, and then decreases back to zero. Like the fast Fourier
  * transform (FFT), the discrete wavelet transform (DWT) is a fast, linear
  * operation that operates on a data vector whose length is an integer power
  * of 2, transforming it into a numerically different vector of the same length.
  * The wavelet transform is invertible and in fact orthogonal. Both FFT and DWT
  * can be viewed as a rotation in function space.
  *
  * @author Haifeng Li
  */
package object wavelet extends Operators {

}