/*
 * Decompiled with CFR 0.152.
 */
package it.blogspot.geoframe.utils.mesh;

import it.blogspot.geoframe.utils.GEOchecks;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.LinkedList;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.RandomIterFactory;
import javax.media.jai.iterator.WritableRandomIter;
import oms3.annotations.Author;
import oms3.annotations.Description;
import oms3.annotations.Execute;
import oms3.annotations.In;
import oms3.annotations.Keywords;
import oms3.annotations.Label;
import oms3.annotations.License;
import oms3.annotations.Name;
import oms3.annotations.Out;
import oms3.annotations.Status;
import org.geotools.coverage.grid.GridCoverage2D;
import org.jgrasstools.gears.utils.RegionMap;
import org.jgrasstools.gears.utils.coverage.CoverageUtilities;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@Description
@Author(name="Giuseppe Formetta", contact="giuseppe.formetta@unical.it")
@Keywords
@Label(value="")
@Name(value="")
@Status
@License(value="")
public class DoGridMesh {
    @Description
    @In
    public GridCoverage2D inSlope = null;
    @Description
    @In
    public boolean doSimmetricMatrix = true;
    @Description
    @Out
    public GridCoverage2D outShalstab = null;
    public final double EPS = 0.01;

    @Execute
    public void process() throws Exception {
        this.inSlope = GEOchecks.checkVariable(this.inSlope);
        RenderedImage slopeRI = this.inSlope.getRenderedImage();
        this.qcrit(slopeRI);
    }

    private void qcrit(RenderedImage slope) {
        int i;
        int i2;
        RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage((GridCoverage2D)this.inSlope);
        int cols = ((Double)regionMap.get("COLS")).intValue();
        int rows = ((Double)regionMap.get("ROWS")).intValue();
        WritableRaster classiWR = CoverageUtilities.createDoubleWritableRaster((int)cols, (int)rows, null, null, null);
        WritableRandomIter classiIter = RandomIterFactory.createWritable((WritableRaster)classiWR, null);
        RandomIter slopeRI = RandomIterFactory.create((RenderedImage)slope, null);
        int contaPoligoni = 0;
        LinkedList<Integer> rowP = new LinkedList<Integer>();
        LinkedList<Integer> colP = new LinkedList<Integer>();
        LinkedList<Integer> valueP = new LinkedList<Integer>();
        for (int j = 0; j < rows; ++j) {
            for (int i3 = 0; i3 < cols; ++i3) {
                double slopeValue = slopeRI.getSampleDouble(i3, j, 0);
                if (!GEOchecks.isNovalue(slopeValue).booleanValue()) {
                    rowP.add(j);
                    colP.add(i3);
                    valueP.add(++contaPoligoni);
                    classiIter.setSample(i3, j, 0, contaPoligoni);
                    continue;
                }
                classiIter.setSample(i3, j, 0, Double.NaN);
            }
        }
        this.outShalstab = CoverageUtilities.buildCoverage((String)"classi", (WritableRaster)classiWR, (HashMap)regionMap, (CoordinateReferenceSystem)this.inSlope.getCoordinateReferenceSystem());
        LinkedList<Integer> rowL = new LinkedList<Integer>();
        LinkedList<Integer> colL = new LinkedList<Integer>();
        LinkedList<Integer> valueL = new LinkedList<Integer>();
        RenderedImage p = this.outShalstab.getRenderedImage();
        RandomIter pRI = RandomIterFactory.create((RenderedImage)p, null);
        for (int j = 0; j < rows; ++j) {
            for (i2 = 0; i2 < cols; ++i2) {
                System.out.println(pRI.getSampleDouble(i2, j, 0));
                if (GEOchecks.isNovalue(pRI.getSampleDouble(i2, j, 0)).booleanValue()) continue;
                if (i2 + 1 < cols && pRI.getSampleDouble(i2 + 1, j, 0) != Double.NaN) {
                    rowL.add((int)pRI.getSampleDouble(i2, j, 0));
                    colL.add((int)pRI.getSampleDouble(i2 + 1, j, 0));
                    valueL.add(2);
                }
                if (i2 - 1 > 0 && pRI.getSampleDouble(i2 - 1, j, 0) != Double.NaN) {
                    rowL.add((int)pRI.getSampleDouble(i2, j, 0));
                    colL.add((int)pRI.getSampleDouble(i2 - 1, j, 0));
                    valueL.add(2);
                }
                if (j + 1 < rows && pRI.getSampleDouble(i2, j + 1, 0) != Double.NaN) {
                    rowL.add((int)pRI.getSampleDouble(i2, j, 0));
                    colL.add((int)pRI.getSampleDouble(i2, j + 1, 0));
                    valueL.add(2);
                }
                if (j - 1 <= 0 || pRI.getSampleDouble(i2, j - 1, 0) == Double.NaN) continue;
                rowL.add((int)pRI.getSampleDouble(i2, j, 0));
                colL.add((int)pRI.getSampleDouble(i2, j - 1, 0));
                valueL.add(2);
            }
        }
        if (this.doSimmetricMatrix) {
            for (int i4 = 0; i4 < colL.size(); ++i4) {
                if ((Integer)rowL.get(i4) <= (Integer)colL.get(i4)) continue;
                System.out.println(rowL.get(i4));
                System.out.println(colL.get(i4));
                valueL.set(i4, -9999);
            }
        }
        int cnt = 0;
        for (i2 = 0; i2 < valueL.size(); ++i2) {
            if ((Integer)valueL.get(i2) == -9999) continue;
            valueL.set(i2, ++cnt);
        }
        LinkedList rowLnew = new LinkedList();
        LinkedList colLnew = new LinkedList();
        LinkedList valueLnew = new LinkedList();
        if (this.doSimmetricMatrix) {
            for (i = 0; i < valueL.size(); ++i) {
                if ((Integer)valueL.get(i) == -9999) continue;
                rowLnew.add(rowL.get(i));
                colLnew.add(colL.get(i));
                valueLnew.add(valueL.get(i));
                rowLnew.add(colL.get(i));
                colLnew.add(rowL.get(i));
                valueLnew.add(valueL.get(i));
            }
        } else {
            rowLnew = rowL;
            colLnew = colL;
            valueLnew = valueL;
        }
        for (i = 1; i < contaPoligoni + 1; ++i) {
            rowLnew.add(i);
            colLnew.add(i);
            valueLnew.add(-1);
        }
        System.out.println("LinkedList contains : " + colLnew);
        System.out.println("LinkedList contains : " + rowLnew);
        System.out.println("LinkedList contains : " + valueLnew);
        System.out.print("ciao");
    }
}

