/*
 * Decompiled with CFR 0.152.
 */
package it.blogspot.geoframe.utils.key;

import it.blogspot.geoframe.utils.key.pairingFunctions.CantorPairing;
import it.blogspot.geoframe.utils.key.pairingFunctions.PairingFunction;
import java.util.List;
import net.jcip.annotations.Immutable;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

@Immutable
public class Key {
    private final String hexKey;
    private PairingFunction pairingFunction;

    public Key(long decimalKey) {
        this.validateLongKey(decimalKey);
        this.hexKey = this.decimalToHex(decimalKey);
    }

    public Key(String hexKey) {
        this.validateStringKey(hexKey);
        this.hexKey = hexKey;
    }

    public Key(Key key) {
        this.validateKey(key);
        this.hexKey = key.getString();
    }

    public Key(long a, long b) {
        this.validateLongKey(a);
        this.validateLongKey(b);
        this.pairingFunction = new CantorPairing();
        long result = this.pairingFunction.computePair(a, b);
        this.hexKey = this.decimalToHex(result);
    }

    public String getString() {
        return this.hexKey;
    }

    public long getInteger() {
        return this.hexToDecimal();
    }

    public List<Integer> getUnpair() {
        if (this.pairingFunction != null) {
            return this.pairingFunction.computeUnpair(this.hexToDecimal());
        }
        String message = "Key has NOT been construct over pairing function";
        throw new NullPointerException(message);
    }

    public boolean isEven() {
        Double division = (double)this.hexToDecimal() / 2.0;
        String tmpString = division.toString();
        String[] result = tmpString.split("\\.");
        return result[1].compareTo("0") == 0;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Key)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        Key rhs = (Key)obj;
        return new EqualsBuilder().append((Object)this.hexKey, (Object)rhs.hexKey).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 3).append((Object)this.hexKey).toHashCode();
    }

    private long hexToDecimal() {
        String DIGITS = "0123456789ABCDEF";
        String HEXKEY = this.hexKey.toUpperCase();
        long decimalVal = 0L;
        for (int i = 0; i < HEXKEY.length(); ++i) {
            char c = HEXKEY.charAt(i);
            int d = "0123456789ABCDEF".indexOf(c);
            decimalVal = 16L * decimalVal + (long)d;
        }
        return decimalVal;
    }

    private String decimalToHex(double decimalVal) {
        String DIGITS = "0123456789abcdef";
        if (decimalVal == 0.0) {
            return "0";
        }
        String hexadecimal = "";
        while (Math.floor(decimalVal) > 0.0) {
            int digit = (int)decimalVal % 16;
            hexadecimal = "0123456789abcdef".charAt(digit) + hexadecimal;
            decimalVal /= 16.0;
        }
        return hexadecimal;
    }

    private void validateStringKey(String hexKey) {
        String DIGITS = "0123456789ABCDEF";
        String HEXKEY = hexKey.toUpperCase();
        for (int i = 0; i < HEXKEY.length(); ++i) {
            char c = HEXKEY.charAt(i);
            int d = "0123456789ABCDEF".indexOf(c);
            if (d >= 0) continue;
            String message = "String '" + hexKey;
            message = message + "' cannot be converted in";
            message = message + "hexadecimal format.\n";
            message = message + c + " is not an hex symbol";
            throw new NumberFormatException(message);
        }
    }

    private void validateKey(Key key) {
        if (key == null) {
            throw new NullPointerException("The input key is null");
        }
    }

    private void validateLongKey(long longKey) {
        if (longKey < 0L) {
            String message = "Negative key - " + longKey;
            message = message + " - are not accepted";
            throw new IllegalArgumentException(message);
        }
    }
}

