/*
 * Decompiled with CFR 0.152.
 */
package querymethods.util;

import org.apache.ibatis.mapping.MappedStatement;
import querymethods.QueryMethodsConfig;
import querymethods.mybatisplus.MybatisPlusUtil;
import querymethods.spring.data.PartTreeFactory;
import querymethods.spring.data.query.parser.PartTree;
import querymethods.tkmapper.TkMapperUtil;
import querymethods.util.MsIdUtil;

public class SqlUtil {
    public static String getSqlByMs(MappedStatement ms) throws ClassNotFoundException, NoSuchFieldException {
        String msId = ms.getId();
        Class<?> entityClass = MsIdUtil.getEntityClass(msId);
        if (entityClass != null) {
            String methodName = MsIdUtil.getMethodName(msId);
            PartTree tree = PartTreeFactory.create(msId, methodName);
            String xmlSql = null;
            if (QueryMethodsConfig.isTkMapper()) {
                xmlSql = SqlUtil.tkMapper(ms, msId, entityClass, tree);
            } else if (QueryMethodsConfig.isMybatisPlus()) {
                xmlSql = SqlUtil.mybatisPlus(ms, msId, entityClass, tree);
            }
            return xmlSql;
        }
        return null;
    }

    private static String tkMapper(MappedStatement ms, String msId, Class<?> entityClass, PartTree tree) throws NoSuchFieldException {
        TkMapperUtil.checkProperty(msId, entityClass, tree);
        String xmlSql = tree.isCountProjection() != false ? TkMapperUtil.selectCountByExample(entityClass) : (tree.isDelete() != false ? TkMapperUtil.deleteByExample(ms, entityClass) : TkMapperUtil.selectByExample(ms, entityClass, tree));
        return "<script>\n\t" + xmlSql + "</script>";
    }

    private static String mybatisPlus(MappedStatement ms, String msId, Class<?> entityClass, PartTree tree) throws NoSuchFieldException {
        MybatisPlusUtil.checkProperty(msId, entityClass, tree);
        String xmlSql = tree.isCountProjection() != false ? MybatisPlusUtil.selectCountByExample(entityClass) : (tree.isDelete() != false ? MybatisPlusUtil.deleteByExample(ms, entityClass) : MybatisPlusUtil.selectByExample(ms, entityClass, tree));
        return xmlSql;
    }
}

