/*
 * Decompiled with CFR 0.152.
 */
package querymethods.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import querymethods.QueryMethodsConfig;
import querymethods.QueryMethodsException;

public class MsIdUtil {
    private static Map<String, String> cacheMethodName = new ConcurrentHashMap<String, String>();
    private static Map<String, Class<?>> cacheMapperClass = new ConcurrentHashMap();
    private static Map<String, Class<?>> cacheEntityClass = new ConcurrentHashMap();

    private MsIdUtil() {
    }

    public static String getMethodName(String msId) {
        String methodName = cacheMethodName.get(msId);
        if (methodName != null) {
            return methodName;
        }
        int lastIndexOf = msId.lastIndexOf(".");
        methodName = msId.substring(lastIndexOf + 1);
        cacheMethodName.put(msId, methodName);
        return methodName;
    }

    public static Class<?> getMapperClass(String msId) {
        Class<?> mapperClass = cacheMapperClass.get(msId);
        if (mapperClass != null) {
            return mapperClass;
        }
        int lastIndexOf = msId.lastIndexOf(".");
        String mapperName = msId.substring(0, lastIndexOf);
        try {
            mapperClass = Class.forName(mapperName);
            cacheMapperClass.put(msId, mapperClass);
            return mapperClass;
        }
        catch (ClassNotFoundException e) {
            throw new QueryMethodsException(e);
        }
    }

    public static Class<?> getEntityClass(String msId) {
        Class<?> entityClass = cacheEntityClass.get(msId);
        if (entityClass != null) {
            return entityClass;
        }
        entityClass = MsIdUtil.getEntityClass(MsIdUtil.getMapperClass(msId));
        cacheEntityClass.put(msId, entityClass);
        return entityClass;
    }

    public static Class<?> getEntityClass(Class<?> mapperClass) {
        Class<?> entityClass = null;
        Type[] genericInterfaces = mapperClass.getGenericInterfaces();
        if (genericInterfaces != null && genericInterfaces.length > 0) {
            for (Type type1 : genericInterfaces) {
                ParameterizedType t = (ParameterizedType)type1;
                if (!QueryMethodsConfig.getMapperClasss().contains(t.getRawType())) continue;
                try {
                    entityClass = Class.forName(t.getActualTypeArguments()[0].getTypeName());
                    break;
                }
                catch (ClassNotFoundException e) {
                    throw new QueryMethodsException(e);
                }
            }
        }
        return entityClass;
    }
}

