/*
 * Decompiled with CFR 0.152.
 */
package querymethods.tkmapper;

import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import querymethods.spring.data.PartTreeFactory;
import querymethods.spring.data.mapping.PropertyPath;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.query.parser.PartTree;
import querymethods.util.IfThen;
import querymethods.util.MsIdUtil;
import tk.mybatis.mapper.MapperException;
import tk.mybatis.mapper.entity.Example;
import tk.mybatis.mapper.util.StringUtil;

public class TkMapperWhereFactory {
    protected static final Log logger = LogFactory.getLog(TkMapperWhereFactory.class);

    private TkMapperWhereFactory() {
    }

    public static Example getExampleByMsId(String msId, Queue<Object> params) throws ClassNotFoundException {
        Class<?> entityClass = MsIdUtil.getEntityClass(msId);
        String methodName = MsIdUtil.getMethodName(msId);
        PartTree tree = PartTreeFactory.create(msId, methodName);
        Example example = new Example(entityClass, true);
        example.setDistinct(tree.isDistinct());
        if (StringUtil.isNotEmpty((String)tree.getQueryProperty())) {
            example.selectProperties(new String[]{tree.getQueryProperty()});
        }
        try {
            Example.Criteria criteria = example.createCriteria();
            for (PartTree.OrPart node : tree) {
                for (Part part : node) {
                    TkMapperWhereFactory.build(part, criteria, params, msId);
                }
                criteria = example.createCriteria();
                example.or(criteria);
            }
        }
        catch (MapperException e) {
            throw new MapperException(e.getMessage() + " -> " + msId, (Throwable)e);
        }
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                Example.OrderBy orderBy = example.orderBy(order.getProperty());
                if (order.isAscending()) {
                    orderBy.asc();
                    continue;
                }
                orderBy.desc();
            }
        }
        return example;
    }

    public static Example createExample(String methodName, Class entityClass, Map<String, Object> param) {
        if (StringUtil.isEmpty((String)methodName)) {
            throw new IllegalArgumentException("methodName must not be empty! [" + methodName + "]");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass must not be null! [" + methodName + "]");
        }
        Example example = new Example(entityClass);
        PartTree tree = new PartTree(methodName);
        example.setDistinct(tree.isDistinct());
        if (StringUtil.isNotEmpty((String)tree.getQueryProperty())) {
            example.selectProperties(new String[]{tree.getQueryProperty()});
        }
        try {
            Example.Criteria criteria = example.createCriteria();
            LinkedList<Object> args = new LinkedList<Object>();
            for (PartTree.OrPart node : tree) {
                for (Part part : node) {
                    boolean converted;
                    Part.Type type = part.getType();
                    boolean bl = converted = type != Part.Type.IS_NOT_NULL && type != Part.Type.IS_NULL && type != Part.Type.TRUE && type != Part.Type.FALSE;
                    if (converted) {
                        PropertyPath pp = part.getProperty();
                        String fieldName = pp.getSegment();
                        Object object = param.get(fieldName);
                        if (IfThen.isEmpty(object)) continue;
                        if (type == Part.Type.BETWEEN) {
                            if (object != null && object.getClass().isArray()) {
                                List<Object> list = Arrays.asList((Object[])object);
                                args.addAll(list);
                            } else if (object instanceof Collection) {
                                args.addAll((Collection)object);
                            } else {
                                args.add(object);
                            }
                        } else {
                            args.add(object);
                        }
                    }
                    TkMapperWhereFactory.build(part, criteria, args, methodName);
                }
                criteria = example.createCriteria();
                example.or(criteria);
            }
        }
        catch (MapperException e) {
            throw new MapperException(e.getMessage() + " -> " + methodName, (Throwable)e);
        }
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                Example.OrderBy orderBy = example.orderBy(order.getProperty());
                if (order.isAscending()) {
                    orderBy.asc();
                    continue;
                }
                orderBy.desc();
            }
        }
        return example;
    }

    public static Example.Criteria build(Part part, Example.Criteria root, Queue<Object> args, String msId) {
        PropertyPath pp = part.getProperty();
        Part.Type type = part.getType();
        String property = pp.getSegment();
        switch (type) {
            case BETWEEN: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                Object b = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andBetween(property, a, b);
            }
            case AFTER: 
            case GREATER_THAN: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andGreaterThan(property, a);
            }
            case GREATER_THAN_EQUAL: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andGreaterThanOrEqualTo(property, a);
            }
            case BEFORE: 
            case LESS_THAN: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLessThan(property, a);
            }
            case LESS_THAN_EQUAL: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLessThanOrEqualTo(property, a);
            }
            case IS_NULL: {
                return root.andIsNull(property);
            }
            case IS_NOT_NULL: {
                return root.andIsNotNull(property);
            }
            case NOT_IN: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andNotIn(property, (Iterable)a);
            }
            case IN: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andIn(property, (Iterable)a);
            }
            case STARTING_WITH: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLike(property, a.toString() + "%");
            }
            case ENDING_WITH: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLike(property, "%" + a.toString());
            }
            case CONTAINING: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLike(property, "%" + a.toString() + "%");
            }
            case NOT_CONTAINING: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andNotLike(property, "%" + a.toString() + "%");
            }
            case LIKE: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andLike(property, a.toString());
            }
            case NOT_LIKE: {
                Object a = TkMapperWhereFactory.checkNotNull(property, args, msId);
                return root.andNotLike(property, a.toString());
            }
            case TRUE: {
                return root.andEqualTo(property, (Object)1);
            }
            case FALSE: {
                return root.andEqualTo(property, (Object)0);
            }
            case SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    return root.andIsNull(property);
                }
                return root.andEqualTo(property, a);
            }
            case NEGATING_SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    return root.andIsNotNull(property);
                }
                return root.andNotEqualTo(property, a);
            }
        }
        throw new IllegalArgumentException("Unsupported keyword " + (Object)((Object)type));
    }

    static Object checkNotNull(String property, Queue<Object> args, String msId) {
        Object param = args.poll();
        if (param == null) {
            throw new IllegalArgumentException("Value must not be null! [" + property + " -> " + msId + "]");
        }
        return param;
    }
}

