/*
 * Decompiled with CFR 0.152.
 */
package querymethods.tkmapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import querymethods.spring.data.mapping.PropertyPath;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.query.parser.PartTree;
import querymethods.util.MetaObjectUtil;
import tk.mybatis.mapper.entity.EntityColumn;
import tk.mybatis.mapper.entity.EntityTable;
import tk.mybatis.mapper.mapperhelper.EntityHelper;
import tk.mybatis.mapper.mapperhelper.SqlHelper;
import tk.mybatis.mapper.util.StringUtil;

public class TkMapperUtil {
    private TkMapperUtil() {
    }

    public static String selectCountByExample(Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        sql.append(SqlHelper.selectCount(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, (String)TkMapperUtil.tableName(entityClass)));
        sql.append(SqlHelper.exampleWhereClause());
        sql.append(SqlHelper.exampleForUpdate());
        return sql.toString();
    }

    public static String selectByExample(MappedStatement ms, Class<?> entityClass, PartTree tree) {
        if (StringUtil.isEmpty((String)tree.getQueryProperty())) {
            TkMapperUtil.setResultType(ms, entityClass);
        }
        StringBuilder sql = new StringBuilder("SELECT ");
        sql.append("<if test=\"distinct\">distinct</if>");
        sql.append(SqlHelper.exampleSelectColumns(entityClass));
        sql.append(SqlHelper.fromTable(entityClass, (String)TkMapperUtil.tableName(entityClass)));
        sql.append(SqlHelper.exampleWhereClause());
        sql.append(SqlHelper.exampleOrderBy(entityClass));
        sql.append(SqlHelper.exampleForUpdate());
        return sql.toString();
    }

    public static String deleteByExample(MappedStatement ms, Class<?> entityClass) {
        StringBuilder sql = new StringBuilder();
        if (SqlHelper.hasLogicDeleteColumn(entityClass)) {
            sql.append(SqlHelper.updateTable(entityClass, (String)TkMapperUtil.tableName(entityClass)));
            sql.append("<set>");
            sql.append(SqlHelper.logicDeleteColumnEqualsValue(entityClass, (boolean)true));
            sql.append("</set>");
            MetaObjectUtil.forObject(ms).setValue("sqlCommandType", (Object)SqlCommandType.UPDATE);
        } else {
            sql.append(SqlHelper.deleteFromTable(entityClass, (String)TkMapperUtil.tableName(entityClass)));
        }
        sql.append(SqlHelper.exampleWhereClause());
        return sql.toString();
    }

    public static String tableName(Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        String prefix = entityTable.getPrefix();
        if (StringUtil.isNotEmpty((String)prefix)) {
            return prefix + "." + entityTable.getName();
        }
        return entityTable.getName();
    }

    public static void setResultType(MappedStatement ms, Class<?> entityClass) {
        EntityTable entityTable = EntityHelper.getEntityTable(entityClass);
        ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
        resultMaps.add(entityTable.getResultMap(ms.getConfiguration()));
        MetaObject metaObject = MetaObjectUtil.forObject(ms);
        metaObject.setValue("resultMaps", Collections.unmodifiableList(resultMaps));
    }

    public static void checkProperty(String msId, Class<?> entityClass, PartTree tree) throws NoSuchFieldException {
        Set columnSet = EntityHelper.getColumns(entityClass);
        Set propertys = columnSet.stream().map(EntityColumn::getProperty).collect(Collectors.toSet());
        for (PartTree.OrPart node : tree) {
            if (StringUtil.isNotEmpty((String)tree.getQueryProperty()) && !propertys.contains(tree.getQueryProperty())) {
                throw new NoSuchFieldException(String.format("%s -> %s", tree.getQueryProperty(), msId));
            }
            for (Part part : node) {
                PropertyPath property = part.getProperty();
                String segment = property.getSegment();
                if (propertys.contains(segment)) continue;
                throw new NoSuchFieldException(String.format("%s -> %s", segment, msId));
            }
        }
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                String property = order.getProperty();
                if (propertys.contains(property)) continue;
                throw new NoSuchFieldException(String.format("%s -> %s", property, msId));
            }
        }
    }
}

