/*
 * Decompiled with CFR 0.152.
 */
package querymethods.spring.data.mapping;

import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import querymethods.spring.data.util.Assert;
import querymethods.spring.data.util.ObjectUtils;
import querymethods.spring.data.util.StringUtils;

public class PropertyPath
implements Iterable<PropertyPath> {
    private static final String PARSE_DEPTH_EXCEEDED = "Trying to parse a path with depth greater than 1000! This has been disabled for security reasons to prevent parsing overflows.";
    private static final String DELIMITERS = "_\\.";
    private static final Pattern SPLITTER = Pattern.compile("(?:[%s]?([%s]*?[^%s]+))".replaceAll("%s", "_\\."));
    private final String name;
    private PropertyPath next;

    PropertyPath(String name) {
        this(name, Collections.emptyList());
    }

    PropertyPath(String name, List<PropertyPath> base) {
        String propertyName;
        Assert.hasText(name, "Name must not be null or empty!");
        Assert.notNull(base, "Perviously found properties must not be null!");
        this.name = propertyName = Introspector.decapitalize(name);
    }

    public String getSegment() {
        return this.name;
    }

    public PropertyPath getLeafProperty() {
        PropertyPath result = this;
        while (result.hasNext()) {
            result = result.next();
        }
        return result;
    }

    public PropertyPath next() {
        return this.next;
    }

    public boolean hasNext() {
        return this.next != null;
    }

    public String toDotPath() {
        if (this.hasNext()) {
            return this.getSegment() + "." + this.next().toDotPath();
        }
        return this.getSegment();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        PropertyPath that = (PropertyPath)obj;
        return this.name.equals(that.name) && ObjectUtils.nullSafeEquals(this.next, that.next);
    }

    public int hashCode() {
        int result = 17;
        result += 31 * this.name.hashCode();
        return result += 31 * (this.next == null ? 0 : this.next.hashCode());
    }

    @Override
    public Iterator<PropertyPath> iterator() {
        return new Iterator<PropertyPath>(){
            private PropertyPath current;
            {
                this.current = PropertyPath.this;
            }

            @Override
            public boolean hasNext() {
                return this.current != null;
            }

            @Override
            public PropertyPath next() {
                PropertyPath result = this.current;
                this.current = this.current.next();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static PropertyPath from(String source) {
        Assert.hasText(source, "Source must not be null or empty!");
        ArrayList<String> iteratorSource = new ArrayList<String>();
        Matcher matcher = SPLITTER.matcher("_" + source);
        while (matcher.find()) {
            iteratorSource.add(matcher.group(1));
        }
        Iterator parts = iteratorSource.iterator();
        PropertyPath result = null;
        Stack<PropertyPath> current = new Stack<PropertyPath>();
        while (parts.hasNext()) {
            if (result == null) {
                result = PropertyPath.createNoTail((String)parts.next(), current);
                current.push(result);
                continue;
            }
            current.push(PropertyPath.create((String)parts.next(), current));
        }
        return result;
    }

    private static PropertyPath create(String source, Stack<PropertyPath> base) {
        PropertyPath propertyPath;
        PropertyPath previous = base.peek();
        previous.next = propertyPath = PropertyPath.create(source, base);
        return propertyPath;
    }

    private static PropertyPath createNoTail(String source, List<PropertyPath> base) {
        return PropertyPath.create(source, "", base);
    }

    private static PropertyPath create(String source, String addTail, List<PropertyPath> base) {
        if (base.size() > 1000) {
            throw new IllegalArgumentException(PARSE_DEPTH_EXCEEDED);
        }
        PropertyPath current = null;
        current = new PropertyPath(source, base);
        if (!base.isEmpty()) {
            base.get((int)(base.size() - 1)).next = current;
        }
        ArrayList<PropertyPath> newBase = new ArrayList<PropertyPath>(base);
        newBase.add(current);
        if (StringUtils.hasText(addTail)) {
            current.next = PropertyPath.createNoTail(addTail, newBase);
        }
        return current;
    }

    public String toString() {
        return String.format("%s", this.toDotPath());
    }
}

