/*
 * Decompiled with CFR 0.152.
 */
package querymethods.mybatisplus;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import org.apache.ibatis.binding.MapperMethod;
import querymethods.mybatisplus.MPTableInfo;
import querymethods.mybatisplus.MybatisPlusUtil;
import querymethods.spring.data.PartTreeFactory;
import querymethods.spring.data.mapping.PropertyPath;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.query.parser.PartTree;
import querymethods.util.IfThen;
import querymethods.util.MsIdUtil;
import tk.mybatis.mapper.util.StringUtil;

public class MybatisPlusWhereFactory {
    public static MapperMethod.ParamMap<Object> getExampleByMsId(String msId, Queue<Object> params) throws ClassNotFoundException {
        String queryProperty;
        Class<?> entityClass = MsIdUtil.getEntityClass(msId);
        String methodName = MsIdUtil.getMethodName(msId);
        PartTree tree = PartTreeFactory.create(msId, methodName);
        QueryWrapper wrapper = new QueryWrapper();
        TableInfo tbInfo = MybatisPlusUtil.getTableInfo(entityClass);
        MPTableInfo tableInfo = MybatisPlusUtil.getMPTableInfo(entityClass);
        String sqlSelect = "";
        if (tree.isDistinct()) {
            sqlSelect = " distinct ";
        }
        if (StringUtils.isNotBlank((CharSequence)(queryProperty = tree.getQueryProperty()))) {
            sqlSelect = sqlSelect + tableInfo.getColumnByProperty(queryProperty);
        } else if (tree.isDistinct()) {
            sqlSelect = sqlSelect + tbInfo.getAllSqlSelect();
        }
        if (!"".equals(sqlSelect)) {
            wrapper.select(new String[]{sqlSelect});
        }
        MybatisPlusWhereFactory.build(params, tree, wrapper, tableInfo, msId);
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                String column = tableInfo.getColumnByProperty(order.getProperty());
                if (order.isAscending()) {
                    wrapper.orderByAsc((Object)column);
                    continue;
                }
                wrapper.orderByDesc((Object)column);
            }
        }
        MapperMethod.ParamMap pm = new MapperMethod.ParamMap();
        pm.put((Object)"ew", (Object)wrapper);
        return pm;
    }

    public static <T> QueryWrapper<T> createQueyWrapper(String methodName, Class<T> entityClass, Map<String, Object> param) {
        String queryProperty;
        if (StringUtil.isEmpty((String)methodName)) {
            throw new IllegalArgumentException("methodName must not be empty! [" + methodName + "]");
        }
        if (entityClass == null) {
            throw new IllegalArgumentException("entityClass must not be null! [" + methodName + "]");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.setEntityClass(entityClass);
        TableInfo tbInfo = MybatisPlusUtil.getTableInfo(entityClass);
        MPTableInfo tableInfo = MybatisPlusUtil.getMPTableInfo(entityClass);
        PartTree tree = new PartTree(methodName);
        String sqlSelect = "";
        if (tree.isDistinct()) {
            sqlSelect = " distinct ";
        }
        if (StringUtils.isNotBlank((CharSequence)(queryProperty = tree.getQueryProperty()))) {
            sqlSelect = sqlSelect + tableInfo.getColumnByProperty(queryProperty);
        } else if (tree.isDistinct()) {
            sqlSelect = sqlSelect + tbInfo.getAllSqlSelect();
        }
        if (!"".equals(sqlSelect)) {
            wrapper.select(new String[]{sqlSelect});
        }
        LinkedList<Object> args = new LinkedList<Object>();
        int index = 0;
        for (PartTree.OrPart node : tree) {
            if (index == 0) {
                for (Part part : node) {
                    if (!MybatisPlusWhereFactory.setArgs(part, param, args)) continue;
                    MybatisPlusWhereFactory.build(part, wrapper, args, tableInfo, methodName);
                }
            } else {
                wrapper.or(i -> {
                    for (Part part : node) {
                        if (!MybatisPlusWhereFactory.setArgs(part, param, args)) continue;
                        MybatisPlusWhereFactory.build(part, i, args, tableInfo, methodName);
                    }
                });
            }
            ++index;
        }
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                if (order.isAscending()) {
                    wrapper.orderByAsc((Object)order.getProperty());
                    continue;
                }
                wrapper.orderByDesc((Object)order.getProperty());
            }
        }
        return wrapper;
    }

    private static boolean setArgs(Part part, Map<String, Object> param, Queue<Object> args) {
        boolean converted;
        Part.Type type = part.getType();
        boolean bl = converted = type != Part.Type.IS_NOT_NULL && type != Part.Type.IS_NULL && type != Part.Type.TRUE && type != Part.Type.FALSE;
        if (converted) {
            PropertyPath pp = part.getProperty();
            String fieldName = pp.getSegment();
            Object object = param.get(fieldName);
            if (IfThen.isEmpty(object)) {
                return false;
            }
            if (type == Part.Type.BETWEEN) {
                if (object != null && object.getClass().isArray()) {
                    List<Object> list = Arrays.asList((Object[])object);
                    args.addAll(list);
                } else if (object instanceof Collection) {
                    args.addAll((Collection)object);
                } else {
                    args.add(object);
                }
            } else {
                args.add(object);
            }
        }
        return true;
    }

    private static void build(Queue<Object> params, PartTree tree, QueryWrapper<?> wrapper, MPTableInfo tableInfo, String msId) {
        int index = 0;
        for (PartTree.OrPart node : tree) {
            if (index == 0) {
                MybatisPlusWhereFactory.andSql(params, wrapper, node, tableInfo, msId);
            } else {
                wrapper.or(i -> MybatisPlusWhereFactory.andSql(params, i, node, tableInfo, msId));
            }
            ++index;
        }
    }

    private static void andSql(Queue<Object> params, QueryWrapper<?> wrapper, PartTree.OrPart node, MPTableInfo tableInfo, String msId) {
        for (Part part : node) {
            MybatisPlusWhereFactory.build(part, wrapper, params, tableInfo, msId);
        }
    }

    public static void build(Part part, QueryWrapper root, Queue<Object> args, MPTableInfo tableInfo, String msId) {
        PropertyPath pp = part.getProperty();
        Part.Type type = part.getType();
        String property = pp.getSegment();
        String column = tableInfo.getColumnByProperty(property);
        switch (type) {
            case BETWEEN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                Object b = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.between((Object)column, a, b);
                break;
            }
            case AFTER: 
            case GREATER_THAN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.gt((Object)column, a);
                break;
            }
            case GREATER_THAN_EQUAL: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.ge((Object)column, a);
                break;
            }
            case BEFORE: 
            case LESS_THAN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.lt((Object)column, a);
                break;
            }
            case LESS_THAN_EQUAL: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.le((Object)column, a);
                break;
            }
            case IS_NULL: {
                root.isNull((Object)column);
                break;
            }
            case IS_NOT_NULL: {
                root.isNotNull((Object)column);
                break;
            }
            case NOT_IN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.notIn((Object)column, ((Collection)a).toArray());
                break;
            }
            case IN: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.in((Object)column, ((Collection)a).toArray());
                break;
            }
            case STARTING_WITH: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.likeLeft((Object)column, a);
                break;
            }
            case ENDING_WITH: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.likeRight((Object)column, a);
                break;
            }
            case CONTAINING: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.like((Object)column, a);
                break;
            }
            case NOT_CONTAINING: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.notLike((Object)column, a);
                break;
            }
            case LIKE: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.apply(column + " like {0}", new Object[]{a});
                break;
            }
            case NOT_LIKE: {
                Object a = MybatisPlusWhereFactory.checkNotNull(property, args, msId);
                root.apply(column + " not like {0}", new Object[]{a});
                break;
            }
            case TRUE: {
                root.eq((Object)column, (Object)1);
                break;
            }
            case FALSE: {
                root.eq((Object)column, (Object)0);
                break;
            }
            case SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    root.isNull((Object)column);
                    break;
                }
                root.eq((Object)column, a);
                break;
            }
            case NEGATING_SIMPLE_PROPERTY: {
                Object a = args.poll();
                if (a == null) {
                    root.isNotNull((Object)column);
                    break;
                }
                root.ne((Object)column, a);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported keyword " + (Object)((Object)type));
            }
        }
    }

    static Object checkNotNull(String property, Queue<Object> args, String msId) {
        Object param = args.poll();
        if (param == null) {
            throw new IllegalArgumentException("Value must not be null! [" + property + " -> " + msId + "]");
        }
        return param;
    }
}

