/*
 * Decompiled with CFR 0.152.
 */
package querymethods.mybatisplus;

import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.ibatis.mapping.MappedStatement;
import querymethods.mybatisplus.AbstractMethodImpl;
import querymethods.mybatisplus.MPTableInfo;
import querymethods.mybatisplus.ResultMapUtil;
import querymethods.spring.data.mapping.PropertyPath;
import querymethods.spring.data.query.domain.Sort;
import querymethods.spring.data.query.parser.Part;
import querymethods.spring.data.query.parser.PartTree;

public class MybatisPlusUtil {
    public static Map<Class<?>, MPTableInfo> map = new ConcurrentHashMap();
    private static AbstractMethodImpl u = new AbstractMethodImpl();

    public static MPTableInfo getMPTableInfo(Class<?> entityClass) {
        return map.get(entityClass);
    }

    public static TableInfo getTableInfo(Class<?> entityClass) {
        TableInfo tableInfo = TableInfoHelper.getTableInfo(entityClass);
        if (null != tableInfo && !map.containsKey(entityClass)) {
            map.put(entityClass, new MPTableInfo(tableInfo));
        }
        return tableInfo;
    }

    public static String selectCountByExample(Class<?> entityClass) {
        TableInfo tableInfo = MybatisPlusUtil.getTableInfo(entityClass);
        SqlMethod sqlMethod = SqlMethod.SELECT_COUNT;
        String sql = String.format(sqlMethod.getSql(), u.sqlFirst(), u.sqlCount(), tableInfo.getTableName(), u.sqlWhereEntityWrapper(true, tableInfo), u.sqlComment());
        return sql.toString();
    }

    public static String selectByExample(MappedStatement ms, Class<?> entityClass, PartTree tree) {
        TableInfo tableInfo = MybatisPlusUtil.getTableInfo(entityClass);
        if (StringUtils.isBlank((CharSequence)tree.getQueryProperty())) {
            ResultMapUtil.setResultType(ms, tableInfo);
        }
        SqlMethod sqlMethod = SqlMethod.SELECT_MAPS;
        String sql = String.format(sqlMethod.getSql(), u.sqlFirst(), u.sqlSelectColumns(tableInfo, true), tableInfo.getTableName(), u.sqlWhereEntityWrapper(true, tableInfo), u.sqlComment());
        return sql.toString();
    }

    public static String deleteByExample(MappedStatement ms, Class<?> entityClass) {
        String sql;
        TableInfo tableInfo = MybatisPlusUtil.getTableInfo(entityClass);
        SqlMethod sqlMethod = SqlMethod.LOGIC_DELETE;
        if (tableInfo.isLogicDelete()) {
            sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), u.sqlLogicSet(tableInfo), u.sqlWhereEntityWrapper(true, tableInfo), u.sqlComment());
        } else {
            sqlMethod = SqlMethod.DELETE;
            sql = String.format(sqlMethod.getSql(), tableInfo.getTableName(), u.sqlWhereEntityWrapper(true, tableInfo), u.sqlComment());
        }
        return sql;
    }

    public static void checkProperty(String msId, Class<?> entityClass, PartTree tree) throws NoSuchFieldException {
        TableInfo tableInfo = MybatisPlusUtil.getTableInfo(entityClass);
        List fieldList = tableInfo.getFieldList();
        Set propertys = fieldList.stream().map(TableFieldInfo::getProperty).collect(Collectors.toSet());
        propertys.add(tableInfo.getKeyProperty());
        for (PartTree.OrPart node : tree) {
            if (StringUtils.isNotBlank((CharSequence)tree.getQueryProperty()) && !propertys.contains(tree.getQueryProperty())) {
                throw new NoSuchFieldException(String.format("%s -> %s", tree.getQueryProperty(), msId));
            }
            for (Part part : node) {
                PropertyPath property = part.getProperty();
                String segment = property.getSegment();
                if (propertys.contains(segment)) continue;
                throw new NoSuchFieldException(String.format("%s -> %s", segment, msId));
            }
        }
        Sort sort = tree.getSort();
        if (sort != null) {
            for (Sort.Order order : sort) {
                String property = order.getProperty();
                if (propertys.contains(property)) continue;
                throw new NoSuchFieldException(String.format("%s -> %s", property, msId));
            }
        }
    }
}

