/*
 * Decompiled with CFR 0.152.
 */
package querymethods;

import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.builder.annotation.ProviderSqlSource;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;
import querymethods.QueryMethodsException;
import querymethods.util.SqlUtil;

public class QueryMethodsHelper {
    protected static final Log logger = LogFactory.getLog(QueryMethodsHelper.class);
    private static final Map<String, Boolean> queryMethod = new ConcurrentHashMap<String, Boolean>();
    private static final Map<String, Boolean> deleteMethod = new ConcurrentHashMap<String, Boolean>();
    private static final XMLLanguageDriver languageDriver = new XMLLanguageDriver();

    private QueryMethodsHelper() {
    }

    public static boolean isQueryMethod(String msId) {
        return queryMethod.containsKey(msId);
    }

    public static boolean isDeleteMethod(String msId) {
        return deleteMethod.containsKey(msId);
    }

    public static void processConfiguration(Configuration configuration) {
        QueryMethodsHelper.processConfiguration(configuration, null);
    }

    public static void processConfiguration(Configuration configuration, Class<?> mapperInterface) {
        String prefix = mapperInterface != null ? mapperInterface.getCanonicalName() : "";
        for (Object object : new ArrayList(configuration.getMappedStatements())) {
            MappedStatement ms;
            if (!(object instanceof MappedStatement) || !(ms = (MappedStatement)object).getId().startsWith(prefix)) continue;
            QueryMethodsHelper.processMappedStatement(ms);
        }
    }

    public static void processMappedStatement(MappedStatement ms) {
        SqlSource sqlSource = ms.getSqlSource();
        if (sqlSource instanceof ProviderSqlSource || sqlSource instanceof DynamicSqlSource) {
            return;
        }
        String msId = ms.getId();
        BoundSql boundSql = sqlSource.getBoundSql(null);
        String sql = boundSql.getSql();
        SqlCommandType sqlCommandType = ms.getSqlCommandType();
        if ("".equals(sql) && (SqlCommandType.SELECT.equals((Object)sqlCommandType) || SqlCommandType.DELETE.equals((Object)sqlCommandType))) {
            try {
                if (queryMethod.containsKey(msId) || deleteMethod.containsKey(msId)) {
                    return;
                }
                if (logger.isInfoEnabled()) {
                    logger.info((Object)("find query methods => " + msId));
                }
                if (SqlCommandType.DELETE.equals((Object)sqlCommandType)) {
                    deleteMethod.put(msId, Boolean.TRUE);
                } else {
                    queryMethod.put(msId, Boolean.TRUE);
                }
                String xmlSql = SqlUtil.getSqlByMs(ms);
                SqlSource s = languageDriver.createSqlSource(ms.getConfiguration(), xmlSql, null);
                MetaObject msObject = SystemMetaObject.forObject((Object)ms);
                msObject.setValue("sqlSource", (Object)s);
            }
            catch (ClassNotFoundException | NoSuchFieldException e) {
                throw new QueryMethodsException(e);
            }
        }
    }
}

