/*
 * Decompiled with CFR 0.152.
 */
package querymethods;

import java.util.ArrayList;
import java.util.List;

public class QueryMethodsConfig {
    public static final String ORM_TYPE_TKMAPPER = "tkmapper";
    public static final String ORM_TYPE_MYBATISPLUS = "mybatis-plus";
    private static String ormType = "tkmapper";
    private static volatile List<Class<?>> mapperClasss = new ArrayList();

    public static String getOrmType() {
        return ormType;
    }

    public static void setOrmType(String ormType) {
        QueryMethodsConfig.ormType = ormType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Class<?>> getMapperClasss() {
        if (!mapperClasss.isEmpty()) return mapperClasss;
        Class<QueryMethodsConfig> clazz = QueryMethodsConfig.class;
        synchronized (QueryMethodsConfig.class) {
            Class<?> clazz2 = QueryMethodsConfig.getTkMapperBaseMapperClass();
            if (clazz2 != null) {
                QueryMethodsConfig.setOrmType(ORM_TYPE_TKMAPPER);
                mapperClasss.add(clazz2);
            } else {
                clazz2 = QueryMethodsConfig.getMybatisPlusBaseMapperClass();
                if (clazz2 == null) return mapperClasss;
                QueryMethodsConfig.setOrmType(ORM_TYPE_MYBATISPLUS);
                mapperClasss.add(clazz2);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return mapperClasss;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setMapperClasss(List<Class<?>> mapperClasss) {
        if (mapperClasss == null) {
            Class<QueryMethodsConfig> clazz = QueryMethodsConfig.class;
            // MONITORENTER : querymethods.QueryMethodsConfig.class
            mapperClasss = new ArrayList();
            // MONITOREXIT : clazz
        }
        QueryMethodsConfig.mapperClasss = mapperClasss;
    }

    public static boolean isTkMapper() {
        boolean isTrue = ORM_TYPE_TKMAPPER.equals(ormType);
        return isTrue;
    }

    public static boolean isMybatisPlus() {
        return ORM_TYPE_MYBATISPLUS.equals(ormType);
    }

    public static Class<?> getTkMapperBaseMapperClass() {
        Class<?> clazz = QueryMethodsConfig.findClass("tk.mybatis.mapper.common.Mapper");
        return clazz;
    }

    public static Class<?> getMybatisPlusBaseMapperClass() {
        Class<?> clazz = QueryMethodsConfig.findClass("com.baomidou.mybatisplus.core.mapper.BaseMapper");
        return clazz;
    }

    public static Class<?> findClass(String className) {
        try {
            Class<?> clazz = Class.forName(className);
            return clazz;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }
}

