/*
 * Decompiled with CFR 0.152.
 */
package joinquery.util;

import joinquery.util.StringUtil;

public class SqlUtil {
    private static String SQL_ORDER_BY_PATTERN = "[a-zA-Z0-9_\\ \\,\\.]+";
    private static final char[] UN_SAFE_CHARS = "'`\"<>&*+=#-;".toCharArray();

    public static void keepColumnSafely(String column) {
        if (StringUtil.isBlank(column)) {
            throw new IllegalArgumentException("Column must not be empty");
        }
        column = column.trim();
        int strLen = column.length();
        for (int i = 0; i < strLen; ++i) {
            char ch = column.charAt(i);
            if (Character.isWhitespace(ch)) {
                throw new IllegalArgumentException("Column must not has space char.");
            }
            if (!SqlUtil.isUnSafeChar(ch)) continue;
            throw new IllegalArgumentException("Column has unsafe char: [" + ch + "].");
        }
    }

    public static void keepOrderBySqlSafely(String value) {
        if (!value.matches(SQL_ORDER_BY_PATTERN)) {
            throw new IllegalArgumentException("Order By sql not safe, order by string: " + value);
        }
    }

    private static boolean isUnSafeChar(char ch) {
        for (char c : UN_SAFE_CHARS) {
            if (c != ch) continue;
            return true;
        }
        return false;
    }
}

