/*
 * Decompiled with CFR 0.152.
 */
package joinquery.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import joinquery.JoinQueryWrapper;
import joinquery.dialect.DbType;
import joinquery.dialect.DbTypeUtil;
import joinquery.dialect.DialectFactory;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ResultMap;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;

public class JoinQueryUtil {
    private static Map<String, DbType> urlDbTypeMap = new ConcurrentHashMap<String, DbType>();
    private static ReentrantLock lock = new ReentrantLock();
    static Pattern pattern = Pattern.compile("#\\{\\w+\\}");

    private JoinQueryUtil() {
    }

    public static <T> List<T> queryList(SqlSession sqlSession, JoinQueryWrapper wrapper, Class<T> resultType) {
        DbType dbType;
        String sql;
        Configuration configuration = sqlSession.getConfiguration();
        if (!configuration.hasStatement(sql = DialectFactory.getDialect(dbType = JoinQueryUtil.getDbType(configuration)).buildSelectSql(wrapper))) {
            RawSqlSource sqlSource = new RawSqlSource(configuration, sql, Map.class);
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, sql, (SqlSource)sqlSource, SqlCommandType.SELECT);
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            resultMaps.add(new ResultMap.Builder(configuration, "defaultResultMap", resultType, new ArrayList(0)).build());
            builder.resultMaps(resultMaps);
            MappedStatement ms = builder.build();
            configuration.addMappedStatement(ms);
        }
        Map<String, Object> parameter = wrapper.getValueMap();
        List selectList = sqlSession.selectList(sql, parameter);
        return selectList;
    }

    public static Integer count(SqlSession sqlSession, JoinQueryWrapper wrapper) {
        DbType dbType;
        String sql;
        Configuration configuration = sqlSession.getConfiguration();
        if (!configuration.hasStatement(sql = DialectFactory.getDialect(dbType = JoinQueryUtil.getDbType(configuration)).buildSelectCountSql(wrapper))) {
            RawSqlSource sqlSource = new RawSqlSource(configuration, sql, Map.class);
            MappedStatement.Builder builder = new MappedStatement.Builder(configuration, sql, (SqlSource)sqlSource, SqlCommandType.SELECT);
            ArrayList<ResultMap> resultMaps = new ArrayList<ResultMap>();
            resultMaps.add(new ResultMap.Builder(configuration, "defaultResultMap", Integer.class, new ArrayList(0)).build());
            builder.resultMaps(resultMaps);
            MappedStatement ms = builder.build();
            configuration.addMappedStatement(ms);
        }
        Map<String, Object> parameter = wrapper.getValueMap();
        Integer selectList = (Integer)sqlSession.selectOne(sql, parameter);
        return selectList;
    }

    public static String querySqlJdbc(DbType dbType, JoinQueryWrapper wrapper) {
        String sql = DialectFactory.getDialect(dbType).buildSelectSql(wrapper);
        return pattern.matcher(sql).replaceAll("?");
    }

    public static String countSqlJdbc(DbType dbType, JoinQueryWrapper wrapper) {
        String sql = DialectFactory.getDialect(dbType).buildSelectCountSql(wrapper);
        return pattern.matcher(sql).replaceAll("?");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbType getDbType(Configuration configuration) {
        DataSource dataSource = configuration.getEnvironment().getDataSource();
        String url = JoinQueryUtil.getUrl(dataSource);
        if (urlDbTypeMap.containsKey(url)) {
            return urlDbTypeMap.get(url);
        }
        try {
            lock.lock();
            if (urlDbTypeMap.containsKey(url)) {
                DbType dbType = urlDbTypeMap.get(url);
                return dbType;
            }
            DbType dbType = DbTypeUtil.parseDbType(url);
            urlDbTypeMap.put(url, dbType);
            DbType dbType2 = dbType;
            return dbType2;
        }
        finally {
            lock.unlock();
        }
    }

    private static String getUrl(DataSource dataSource) {
        Connection conn = null;
        try {
            conn = dataSource.getConnection();
            String string = conn.getMetaData().getURL();
            return string;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }
}

