/*
 * Decompiled with CFR 0.152.
 */
package joinquery.processer;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import joinquery.processer.AbstractQueryEntityProcesser;

public class MybatisPlusQueryEntityProcesser
extends AbstractQueryEntityProcesser {
    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        this.filer = processingEnvironment.getFiler();
    }

    @Override
    public String getTableName(Element t) {
        Map<String, AnnotationValue> defaultValues = this.getAnnotationDefaultValues(t, "com.baomidou.mybatisplus.annotation.TableName");
        AnnotationValue tabnename = defaultValues.get("value");
        if (tabnename != null && !"\"\"".equals(((Object)tabnename).toString()) && ((Object)tabnename).toString().trim().length() > 0) {
            return ((Object)tabnename).toString().trim().replace("\"", "");
        }
        return null;
    }

    @Override
    public String getColumnName(Element t) {
        Map<String, AnnotationValue> defaultValues = this.getAnnotationDefaultValues(t, "com.baomidou.mybatisplus.annotation.TableField");
        AnnotationValue fieldname = defaultValues.get("value");
        if (fieldname != null && !"\"\"".equals(((Object)fieldname).toString()) && ((Object)fieldname).toString().trim().length() > 0) {
            return ((Object)fieldname).toString().trim().replace("\"", "");
        }
        return null;
    }

    @Override
    public Boolean isIgnoreColumn(Element t) {
        Map<String, AnnotationValue> defaultValues = this.getAnnotationDefaultValues(t, "com.baomidou.mybatisplus.annotation.TableField");
        AnnotationValue exist = defaultValues.get("exist");
        if (exist != null) {
            return Boolean.FALSE.equals(exist.getValue());
        }
        return false;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            for (TypeElement typeElement : annotations) {
                if (typeElement.getKind() != ElementKind.ANNOTATION_TYPE) continue;
                try {
                    Set<? extends Element> annotatedMappers = roundEnv.getElementsAnnotatedWith(typeElement);
                    super.process(annotatedMappers);
                }
                catch (Throwable t) {
                    this.handleUncaughtError(typeElement, t);
                }
            }
        }
        return false;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> supportedAnnotationTypes = new HashSet<String>();
        supportedAnnotationTypes.add("com.baomidou.mybatisplus.annotation.TableName");
        return supportedAnnotationTypes;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }
}

