/*
 * Decompiled with CFR 0.152.
 */
package joinquery.processer;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Properties;

class JoinProps {
    protected Properties properties = new Properties();
    private static final String DEFAULT_ENCODING = "UTF-8";

    public JoinProps(String fileName) {
        this(fileName, DEFAULT_ENCODING);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JoinProps(String fileName, String encoding) {
        InputStream inputStream = null;
        try {
            String classPath;
            URL resourceURL;
            inputStream = this.getResourceAsStreamByCurrentThread(fileName);
            if (inputStream == null) {
                inputStream = this.getResourceAsStreamByClassloader(fileName);
            }
            if (inputStream == null && (resourceURL = JoinProps.class.getResource("/")) != null && JoinProps.removeSlashEnd(classPath = resourceURL.toURI().getPath()).endsWith("classes")) {
                File propFile = new File(classPath, fileName);
                if (propFile.exists() && propFile.isFile()) {
                    inputStream = new FileInputStream(propFile);
                } else {
                    File resourcesDir = new File(classPath, "../../src/main/resources");
                    propFile = new File(resourcesDir, fileName);
                    if (propFile.exists() && propFile.isFile()) {
                        inputStream = new FileInputStream(propFile);
                    }
                }
            }
            if (inputStream != null) {
                this.properties.load(new InputStreamReader(inputStream, encoding));
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private InputStream getResourceAsStreamByCurrentThread(String fileName) {
        ClassLoader ret = Thread.currentThread().getContextClassLoader();
        return ret != null ? ret.getResourceAsStream(fileName) : null;
    }

    private InputStream getResourceAsStreamByClassloader(String fileName) {
        ClassLoader ret = JoinProps.class.getClassLoader();
        return ret != null ? ret.getResourceAsStream(fileName) : null;
    }

    private static String removeSlashEnd(String path) {
        if (path != null && (path.endsWith("/") || path.endsWith("\\"))) {
            return path.substring(0, path.length() - 1);
        }
        return path;
    }

    public Properties getProperties() {
        return this.properties;
    }
}

