/*
 * Decompiled with CFR 0.152.
 */
package joinquery.processer;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import joinquery.processer.Ignore;
import joinquery.processer.JoinProps;

public abstract class AbstractQueryEntityProcesser
extends AbstractProcessor {
    private static final String classTableTemplate = "package @package;\n\nimport joinquery.QueryColumn;\nimport joinquery.TableDef;\n\n// Auto generate by mybatis-joinquery, do not modify it.\npublic class Tables {\n@classesInfo}\n";
    private static final String tableDefTemplate = "\n\n    public static final @entityClassTableDef @tableField = new @entityClassTableDef(\"@tableName\");\n";
    private static final String classTemplate = "\n    public static class @entityClassTableDef extends TableDef {\n\n@queryColumns@defaultColumns@allColumns\n        public @entityClassTableDef(String tableName) {\n            super(tableName);\n        }\n    }\n";
    private static final String columnsTemplate = "        public QueryColumn @property = new QueryColumn(this, \"@columnName\");\n";
    private static final String defaultColumnsTemplate = "\n        public QueryColumn[] DEFAULT_COLUMNS = new QueryColumn[]{@allColumns};\n";
    private static final String allColumnsTemplate = "        public QueryColumn[] ALL_COLUMNS = new QueryColumn[]{@allColumns};\n\n";
    protected Filer filer;

    public AnnotationMirror getAnnotationMirror(Element t, String annotationClassName) {
        AnnotationMirror mirror = t.getAnnotationMirrors().stream().filter(a -> annotationClassName.contentEquals(((TypeElement)a.getAnnotationType().asElement()).getQualifiedName())).findAny().orElse(null);
        return mirror;
    }

    public Map<String, AnnotationValue> getAnnotationDefaultValues(Element t, String annotationClassName) {
        AnnotationMirror mirror = this.getAnnotationMirror(t, annotationClassName);
        if (mirror == null) {
            return new HashMap<String, AnnotationValue>(0);
        }
        List<ExecutableElement> enclosed = ElementFilter.methodsIn(mirror.getAnnotationType().asElement().getEnclosedElements());
        HashMap<String, AnnotationValue> values = new HashMap<String, AnnotationValue>(enclosed.size());
        mirror.getElementValues().entrySet().forEach(e -> {
            AnnotationValue cfr_ignored_0 = (AnnotationValue)values.put(((ExecutableElement)e.getKey()).getSimpleName().toString(), (AnnotationValue)e.getValue());
        });
        return values;
    }

    public abstract String getTableName(Element var1);

    public abstract String getColumnName(Element var1);

    public abstract Boolean isIgnoreColumn(Element var1);

    public boolean process(Set<? extends Element> elementsAnnotatedWith) {
        JoinProps props = new JoinProps("mybatis-joinquery.properties");
        String enable = props.getProperties().getProperty("processer.enable", "");
        if ("false".equalsIgnoreCase(enable)) {
            return true;
        }
        String genPath = props.getProperties().getProperty("processer.genPath", "");
        String genTablesPackage = props.getProperties().getProperty("processer.tablesPackage");
        String className = props.getProperties().getProperty("processer.tablesClassName", "Tables");
        StringBuilder guessPackage = new StringBuilder();
        StringBuilder tablesContent = new StringBuilder();
        elementsAnnotatedWith.forEach(entityClassElement -> {
            if (entityClassElement.getAnnotation(Ignore.class) != null) {
                return;
            }
            String tableName = AbstractQueryEntityProcesser.firstCharToLowerCase(entityClassElement.getSimpleName().toString());
            String n = this.getTableName((Element)entityClassElement);
            if (n != null && !n.isEmpty()) {
                tableName = n;
            }
            if ((genTablesPackage == null || genTablesPackage.trim().length() == 0) && guessPackage.length() == 0) {
                String entityClassName = entityClassElement.toString();
                if (!entityClassName.contains(".")) {
                    guessPackage.append("table");
                } else {
                    guessPackage.append(entityClassName.substring(0, entityClassName.lastIndexOf(".")) + ".table");
                }
            }
            LinkedHashMap<String, String> propertyAndColumns = new LinkedHashMap<String, String>();
            ArrayList<String> defaultColumns = new ArrayList<String>();
            TypeElement classElement = (TypeElement)entityClassElement;
            for (Element element : classElement.getEnclosedElements()) {
                if (element.getModifiers().contains((Object)Modifier.STATIC) || ElementKind.FIELD != element.getKind() || Boolean.TRUE.equals(this.isIgnoreColumn(element))) continue;
                String columnName = AbstractQueryEntityProcesser.camelToUnderline(element.toString());
                String n1 = this.getColumnName(element);
                if (n1 != null && !n1.isEmpty()) {
                    columnName = n1;
                }
                propertyAndColumns.put(element.toString(), columnName);
                defaultColumns.add(element.toString());
            }
            String entityClassName = entityClassElement.getSimpleName().toString();
            tablesContent.append(this.buildTablesClass(entityClassName, tableName, propertyAndColumns, defaultColumns));
        });
        if (tablesContent.length() > 0) {
            String realGenPackage = genTablesPackage == null || genTablesPackage.trim().length() == 0 ? guessPackage.toString() : genTablesPackage;
            this.genTablesClass(genPath, realGenPackage, className, tablesContent.toString());
        }
        return false;
    }

    private String buildTablesClass(String entityClass, String tableName, Map<String, String> propertyAndColumns, List<String> defaultColumns) {
        String tableDef = tableDefTemplate.replace("@entityClass", entityClass).replace("@tableField", entityClass.toUpperCase()).replace("@tableName", tableName);
        StringBuilder queryColumns = new StringBuilder();
        propertyAndColumns.forEach((property, column) -> queryColumns.append(columnsTemplate.replace("@property", AbstractQueryEntityProcesser.camelToUnderline(property).toUpperCase()).replace("@columnName", (CharSequence)column)));
        StringJoiner allColumns = new StringJoiner(", ");
        propertyAndColumns.forEach((property, column) -> allColumns.add(AbstractQueryEntityProcesser.camelToUnderline(property).toUpperCase()));
        String allColumnsString = allColumnsTemplate.replace("@allColumns", allColumns.toString());
        StringJoiner defaultColumnStringJoiner = new StringJoiner(", ");
        defaultColumns.forEach(s -> defaultColumnStringJoiner.add(AbstractQueryEntityProcesser.camelToUnderline(s).toUpperCase()));
        String defaultColumnsString = defaultColumnsTemplate.replace("@allColumns", defaultColumnStringJoiner.toString());
        String tableClass = classTemplate.replace("@entityClass", entityClass).replace("@queryColumns", queryColumns).replace("@defaultColumns", defaultColumnsString).replace("@allColumns", allColumnsString);
        return tableDef + tableClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void genTablesClass(String genBasePath, String genPackageName, String className, String classContent) {
        String genContent = classTableTemplate.replace("@package", genPackageName).replace("@classesInfo", classContent);
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (genBasePath == null || genBasePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                this.printMessage(">>>>> joinquery success generate tables class: \n" + sourceFile.toUri());
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (AbstractQueryEntityProcesser.isAbsolutePath(genBasePath)) {
                realPath = genBasePath;
            } else {
                String projectRootPath = this.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, genBasePath).getAbsolutePath();
            }
            boolean fromTestSource = this.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by mybatis-joinquery processer for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
            this.printMessage(">>>>> mybatis-joinquery success generate tables class: \n" + genJavaFile.toURI());
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void printMessage(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, message);
        System.out.println(message);
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    public static boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getProjectRootPath(file, count);
    }

    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getProjectRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getProjectRootPath(file.getParentFile(), --count);
    }

    protected void handleUncaughtError(Element element, Throwable thrown) {
        StringWriter sw = new StringWriter();
        thrown.printStackTrace(new PrintWriter(sw));
        String reportableStacktrace = sw.toString().replace(System.lineSeparator(), "  ");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Internal error in the mapping processor: " + reportableStacktrace, element);
    }
}

