/*
 * Decompiled with CFR 0.152.
 */
package joinquery.interceptor;

import java.util.Properties;
import joinquery.dialect.DbType;
import joinquery.dialect.DialectFactory;
import joinquery.util.JoinQueryUtil;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class})})
public class DbTypeInterceptor
implements Interceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object intercept(Invocation invocation) throws Throwable {
        Object[] args = invocation.getArgs();
        MappedStatement ms = (MappedStatement)args[0];
        DbType dbType = JoinQueryUtil.getDbType(ms.getConfiguration());
        try {
            DialectFactory.setHintDbType(dbType);
            Object object = invocation.proceed();
            return object;
        }
        finally {
            DialectFactory.clearHintDbType();
        }
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }
}

