/*
 * Decompiled with CFR 0.152.
 */
package joinquery.dialect;

import java.util.regex.Pattern;
import joinquery.dialect.DbType;

public class DbTypeUtil {
    public static DbType parseDbType(String jdbcUrl) {
        if ((jdbcUrl = jdbcUrl.toLowerCase()).contains(":mysql:") || jdbcUrl.contains(":cobar:")) {
            return DbType.MYSQL;
        }
        if (jdbcUrl.contains(":mariadb:")) {
            return DbType.MARIADB;
        }
        if (jdbcUrl.contains(":oracle:")) {
            return DbType.ORACLE;
        }
        if (jdbcUrl.contains(":sqlserver:") || jdbcUrl.contains(":microsoft:")) {
            return DbType.SQL_SERVER2005;
        }
        if (jdbcUrl.contains(":sqlserver2012:")) {
            return DbType.SQL_SERVER;
        }
        if (jdbcUrl.contains(":postgresql:")) {
            return DbType.POSTGRE_SQL;
        }
        if (jdbcUrl.contains(":hsqldb:")) {
            return DbType.HSQL;
        }
        if (jdbcUrl.contains(":db2:")) {
            return DbType.DB2;
        }
        if (jdbcUrl.contains(":sqlite:")) {
            return DbType.SQLITE;
        }
        if (jdbcUrl.contains(":h2:")) {
            return DbType.H2;
        }
        if (DbTypeUtil.isMatchedRegex(":dm\\d*:", jdbcUrl)) {
            return DbType.DM;
        }
        if (jdbcUrl.contains(":xugu:")) {
            return DbType.XU_GU;
        }
        if (DbTypeUtil.isMatchedRegex(":kingbase\\d*:", jdbcUrl)) {
            return DbType.KINGBASE_ES;
        }
        if (jdbcUrl.contains(":phoenix:")) {
            return DbType.PHOENIX;
        }
        if (jdbcUrl.contains(":zenith:")) {
            return DbType.GAUSS;
        }
        if (jdbcUrl.contains(":gbase:")) {
            return DbType.GBASE;
        }
        if (jdbcUrl.contains(":gbasedbt-sqli:") || jdbcUrl.contains(":informix-sqli:")) {
            return DbType.GBASE_8S;
        }
        if (jdbcUrl.contains(":ch:") || jdbcUrl.contains(":clickhouse:")) {
            return DbType.CLICK_HOUSE;
        }
        if (jdbcUrl.contains(":oscar:")) {
            return DbType.OSCAR;
        }
        if (jdbcUrl.contains(":sybase:")) {
            return DbType.SYBASE;
        }
        if (jdbcUrl.contains(":oceanbase:")) {
            return DbType.OCEAN_BASE;
        }
        if (jdbcUrl.contains(":highgo:")) {
            return DbType.HIGH_GO;
        }
        if (jdbcUrl.contains(":cubrid:")) {
            return DbType.CUBRID;
        }
        if (jdbcUrl.contains(":goldilocks:")) {
            return DbType.GOLDILOCKS;
        }
        if (jdbcUrl.contains(":csiidb:")) {
            return DbType.CSIIDB;
        }
        if (jdbcUrl.contains(":sap:")) {
            return DbType.SAP_HANA;
        }
        if (jdbcUrl.contains(":impala:")) {
            return DbType.IMPALA;
        }
        if (jdbcUrl.contains(":vertica:")) {
            return DbType.VERTICA;
        }
        if (jdbcUrl.contains(":xcloud:")) {
            return DbType.XCloud;
        }
        if (jdbcUrl.contains(":firebirdsql:")) {
            return DbType.FIREBIRD;
        }
        if (jdbcUrl.contains(":redshift:")) {
            return DbType.REDSHIFT;
        }
        if (jdbcUrl.contains(":opengauss:")) {
            return DbType.OPENGAUSS;
        }
        if (jdbcUrl.contains(":taos:") || jdbcUrl.contains(":taos-rs:")) {
            return DbType.TDENGINE;
        }
        if (jdbcUrl.contains(":informix")) {
            return DbType.INFORMIX;
        }
        if (jdbcUrl.contains(":uxdb:")) {
            return DbType.UXDB;
        }
        if (jdbcUrl.contains(":greenplum:")) {
            return DbType.GREENPLUM;
        }
        return DbType.OTHER;
    }

    public static boolean isMatchedRegex(String regex, String jdbcUrl) {
        if (null == jdbcUrl) {
            return false;
        }
        return Pattern.compile(regex).matcher(jdbcUrl).find();
    }
}

