/*
 * Decompiled with CFR 0.152.
 */
package joinquery.dialect;

import java.util.List;
import joinquery.CPI;
import joinquery.JoinQueryWrapper;
import joinquery.QueryTable;
import joinquery.dialect.IDialect;
import joinquery.dialect.KeywordWrap;
import joinquery.dialect.LimitOffsetProcesser;
import joinquery.util.CollectionUtil;
import joinquery.util.StringUtil;

public class CommonsDialectImpl
implements IDialect {
    protected KeywordWrap keywordWrap = KeywordWrap.BACKQUOTE;
    private LimitOffsetProcesser limitOffsetProcesser = LimitOffsetProcesser.MYSQL;

    public CommonsDialectImpl() {
    }

    public CommonsDialectImpl(LimitOffsetProcesser limitOffsetProcesser) {
        this.limitOffsetProcesser = limitOffsetProcesser;
    }

    public CommonsDialectImpl(KeywordWrap keywordWrap, LimitOffsetProcesser limitOffsetProcesser) {
        this.keywordWrap = keywordWrap;
        this.limitOffsetProcesser = limitOffsetProcesser;
    }

    @Override
    public String wrap(String keyword) {
        return this.keywordWrap.wrap(keyword);
    }

    @Override
    public String buildSelectSql(JoinQueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = CPI.getBaseQuerySql(queryWrapper, this);
        CPI.buildWhereSql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildGroupBySql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildHavingSql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildOrderBySql(sqlBuilder, queryWrapper, allTables, this);
        Integer limitRows = CPI.getLimitRows(queryWrapper);
        Integer limitOffset = CPI.getLimitOffset(queryWrapper);
        if (limitRows != null || limitOffset != null) {
            sqlBuilder = this.buildLimitOffsetSql(sqlBuilder, queryWrapper, limitRows, limitOffset);
        }
        return sqlBuilder.toString();
    }

    @Override
    public String buildSelectCountSql(JoinQueryWrapper queryWrapper) {
        List<QueryTable> queryTables = CPI.getQueryTables(queryWrapper);
        List<QueryTable> joinTables = CPI.getJoinTables(queryWrapper);
        List<QueryTable> allTables = CollectionUtil.merge(queryTables, joinTables);
        StringBuilder sqlBuilder = new StringBuilder("SELECT COUNT(*) FROM ");
        sqlBuilder.append(StringUtil.join(", ", queryTables, queryTable -> queryTable.toSql(this)));
        CPI.buildWhereSql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildGroupBySql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildHavingSql(sqlBuilder, queryWrapper, allTables, this);
        CPI.buildOrderBySql(sqlBuilder, queryWrapper, allTables, this);
        return sqlBuilder.toString();
    }

    protected StringBuilder buildLimitOffsetSql(StringBuilder sqlBuilder, JoinQueryWrapper queryWrapper, Integer limitRows, Integer limitOffset) {
        return this.limitOffsetProcesser.process(sqlBuilder, queryWrapper, limitRows, limitOffset);
    }

    protected String buildQuestion(int count, boolean withBrackets) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            sb.append("?");
            if (i == count - 1) continue;
            sb.append(", ");
        }
        return withBrackets ? "(" + sb + ")" : sb.toString();
    }
}

