/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import joinquery.JoinQueryWrapper;
import joinquery.QueryCondition;
import joinquery.QueryTable;
import joinquery.util.StringUtil;

class WrapperUtil {
    static final Object[] NULL_PARA_ARRAY = new Object[0];

    WrapperUtil() {
    }

    static String buildAsAlias(String alias) {
        return StringUtil.isBlank(alias) ? "" : " AS " + alias;
    }

    static Object[] getValues(QueryCondition condition) {
        if (condition == null) {
            return NULL_PARA_ARRAY;
        }
        LinkedList<Object> paras = new LinkedList<Object>();
        WrapperUtil.getValues(condition, paras);
        return paras.isEmpty() ? NULL_PARA_ARRAY : paras.toArray();
    }

    private static void getValues(QueryCondition condition, List<Object> paras) {
        if (condition == null) {
            return;
        }
        Object value = condition.getValue();
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] values;
                for (Object object : values = (Object[])value) {
                    if (object != null && (object.getClass().isArray() || object.getClass() == int[].class || object.getClass() == long[].class || object.getClass() == short[].class || object.getClass() == float[].class || object.getClass() == double[].class)) {
                        for (int i = 0; i < Array.getLength(object); ++i) {
                            paras.add(Array.get(object, i));
                        }
                        continue;
                    }
                    paras.add(object);
                }
            } else if (value instanceof JoinQueryWrapper) {
                Object[] valueArray = ((JoinQueryWrapper)value).getValueArray();
                paras.addAll(Arrays.asList(valueArray));
            } else {
                paras.add(value);
            }
        }
        WrapperUtil.getValues(condition.next, paras);
    }

    static Map<String, Object> getValuesMap(QueryCondition condition) {
        if (condition == null) {
            return null;
        }
        LinkedHashMap<String, Object> paras = new LinkedHashMap<String, Object>();
        WrapperUtil.getValuesMap(condition, paras);
        return paras;
    }

    private static void getValuesMap(QueryCondition condition, Map<String, Object> paras) {
        if (condition == null) {
            return;
        }
        Object value = condition.getValue();
        if (value != null) {
            if (value.getClass().isArray()) {
                Object[] values = (Object[])value;
                for (int idx = 0; idx < values.length; ++idx) {
                    Object object = values[idx];
                    if (object != null && (object.getClass().isArray() || object.getClass() == int[].class || object.getClass() == long[].class || object.getClass() == short[].class || object.getClass() == float[].class || object.getClass() == double[].class)) {
                        for (int i = 0; i < Array.getLength(object); ++i) {
                            paras.put("p" + condition.index + "" + i, Array.get(object, i));
                        }
                        continue;
                    }
                    paras.put("p" + condition.index + "" + idx, object);
                }
            } else if (value instanceof JoinQueryWrapper) {
                Map<String, Object> valueArray = ((JoinQueryWrapper)value).getValueMap();
                paras.putAll(valueArray);
            } else {
                paras.put("p" + condition.index + "", value);
            }
        }
        WrapperUtil.getValuesMap(condition.next, paras);
    }

    public static String getColumnTableName(List<QueryTable> queryTables, QueryTable queryTable) {
        if (queryTables == null) {
            return "";
        }
        if (queryTables.size() == 1 && queryTables.get(0).isSameTable(queryTable)) {
            return "";
        }
        QueryTable realTable = WrapperUtil.getRealTable(queryTables, queryTable);
        if (realTable == null) {
            return "";
        }
        return StringUtil.isNotBlank(realTable.alias) ? realTable.alias : realTable.name;
    }

    public static QueryTable getRealTable(List<QueryTable> queryTables, QueryTable queryTable) {
        if (queryTables == null || queryTables.isEmpty()) {
            return queryTable;
        }
        if (queryTable == null && queryTables.size() == 1) {
            return queryTables.get(0);
        }
        for (QueryTable table : queryTables) {
            if (!table.isSameTable(queryTable)) continue;
            return table;
        }
        return queryTable;
    }
}

