/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.List;
import java.util.function.Supplier;
import joinquery.Brackets;
import joinquery.JoinQueryWrapper;
import joinquery.QueryColumn;
import joinquery.QueryTable;
import joinquery.SqlConnector;
import joinquery.dialect.IDialect;

public class QueryCondition
implements Serializable {
    public static final String LOGIC_LIKE = "LIKE";
    public static final String LOGIC_GT = ">";
    public static final String LOGIC_GE = ">=";
    public static final String LOGIC_LT = "<";
    public static final String LOGIC_LE = "<=";
    public static final String LOGIC_EQUALS = "=";
    public static final String LOGIC_NOT_EQUALS = "!=";
    public static final String LOGIC_IS_NULL = "IS NULL";
    public static final String LOGIC_IS_NOT_NULL = "IS NOT NULL";
    public static final String LOGIC_IN = "IN";
    public static final String LOGIC_NOT_IN = "NOT IN";
    public static final String LOGIC_BETWEEN = "BETWEEN";
    public static final String LOGIC_NOT_BETWEEN = "NOT BETWEEN";
    protected QueryColumn column;
    protected String logic;
    protected Object value;
    protected boolean effective = true;
    public int index = 0;
    protected QueryCondition before;
    protected QueryCondition next;
    protected SqlConnector connector;

    public static QueryCondition createEmpty() {
        return new QueryCondition().when(false);
    }

    public static QueryCondition create(QueryColumn queryColumn, Object value) {
        return QueryCondition.create(queryColumn, LOGIC_EQUALS, value);
    }

    public static QueryCondition create(QueryColumn queryColumn, String logic, Object value) {
        QueryCondition column = new QueryCondition();
        column.setColumn(queryColumn);
        column.setLogic(logic);
        column.setValue(value);
        return column;
    }

    public QueryColumn getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumn column) {
        this.column = column;
    }

    public Object getValue() {
        return this.checkEffective() ? this.value : null;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public String getLogic() {
        return this.logic;
    }

    public void setLogic(String logic) {
        this.logic = logic;
    }

    public QueryCondition when(boolean effective) {
        this.effective = effective;
        return this;
    }

    public void when(Supplier<Boolean> fn) {
        this.effective = fn.get();
    }

    public boolean checkEffective() {
        return this.effective;
    }

    public QueryCondition and(QueryCondition nextCondition) {
        return new Brackets(this).and(nextCondition);
    }

    public QueryCondition or(QueryCondition nextCondition) {
        return new Brackets(this).or(nextCondition);
    }

    protected void connect(QueryCondition nextCondition, SqlConnector connector) {
        if (this.next != null) {
            this.next.connect(nextCondition, connector);
        } else {
            this.next = nextCondition;
            this.connector = connector;
            nextCondition.before = this;
        }
    }

    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.getColumn().toConditionSql(queryTables, dialect));
            sql.append(" ").append(this.logic).append(" ");
            if (this.value instanceof QueryColumn) {
                sql.append(((QueryColumn)this.value).toConditionSql(queryTables, dialect));
            } else if (this.value instanceof JoinQueryWrapper) {
                sql.append("(").append(dialect.buildSelectSql((JoinQueryWrapper)this.value)).append(")");
            } else {
                this.appendQuestionMark(sql);
            }
        }
        if (this.next != null) {
            this.next.index = this.index + 1;
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    protected QueryCondition getEffectiveBefore() {
        if (this.before != null && this.before.checkEffective()) {
            return this.before;
        }
        if (this.before != null) {
            return this.before.getEffectiveBefore();
        }
        return null;
    }

    protected void appendQuestionMark(StringBuilder sqlBuilder) {
        if (!(LOGIC_IS_NULL.equals(this.logic) || LOGIC_IS_NOT_NULL.equals(this.logic) || this.value instanceof QueryColumn || this.value instanceof JoinQueryWrapper)) {
            if (LOGIC_BETWEEN.equals(this.logic) || LOGIC_NOT_BETWEEN.equals(this.logic)) {
                sqlBuilder.append(" #{p").append(this.index).append("0").append("} AND ").append(" #{p").append(this.index + "" + 1).append("} ");
            } else if (LOGIC_IN.equals(this.logic) || LOGIC_NOT_IN.equals(this.logic)) {
                int paramsCount = this.calculateValueArrayCount();
                sqlBuilder.append('(');
                for (int i = 0; i < paramsCount; ++i) {
                    sqlBuilder.append(" #{p").append(this.index).append(i).append("} ");
                    if (i == paramsCount - 1) continue;
                    sqlBuilder.append(',');
                }
                sqlBuilder.append(')');
            } else {
                sqlBuilder.append(" #{p").append(this.index).append("} ");
            }
        }
    }

    private int calculateValueArrayCount() {
        Object[] values = (Object[])this.value;
        int paramsCount = 0;
        for (Object object : values) {
            if (object != null && (object.getClass().isArray() || object.getClass() == int[].class || object.getClass() == long[].class || object.getClass() == short[].class || object.getClass() == float[].class || object.getClass() == double[].class)) {
                paramsCount += Array.getLength(object);
                continue;
            }
            ++paramsCount;
        }
        return paramsCount;
    }

    public String toString() {
        return "QueryCondition{column=" + this.column + ", logic='" + this.logic + '\'' + ", value=" + this.value + ", effective=" + this.effective + '}';
    }
}

