/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.List;
import joinquery.JoinQueryWrapper;
import joinquery.QueryCondition;
import joinquery.QueryTable;
import joinquery.dialect.IDialect;
import joinquery.util.StringUtil;

public class OperatorSelectCondition
extends QueryCondition {
    private String operator;
    private JoinQueryWrapper queryWrapper;

    public OperatorSelectCondition(String operator, JoinQueryWrapper queryWrapper) {
        this.operator = operator;
        this.queryWrapper = queryWrapper;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.isNotBlank(childSql = dialect.buildSelectSql(this.queryWrapper))) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return this.queryWrapper.getValueArray();
    }
}

