/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.List;
import joinquery.QueryCondition;
import joinquery.QueryTable;
import joinquery.WrapperUtil;
import joinquery.dialect.IDialect;
import joinquery.util.StringUtil;

public class OperatorQueryCondition
extends QueryCondition {
    private String operator;
    private QueryCondition child;

    public OperatorQueryCondition(String operator, QueryCondition child) {
        this.operator = operator;
        this.child = child;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        String childSql;
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective() && StringUtil.isNotBlank(childSql = this.child.toSql(queryTables, dialect))) {
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                sql.append((Object)effectiveBefore.connector);
            }
            sql.append(this.operator).append("(").append(childSql).append(")");
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public Object getValue() {
        return WrapperUtil.getValues(this.child);
    }
}

