/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import joinquery.BaseQueryWrapper;
import joinquery.Join;
import joinquery.Joiner;
import joinquery.QueryColumn;
import joinquery.QueryCondition;
import joinquery.QueryOrderBy;
import joinquery.QueryTable;
import joinquery.SelectQueryTable;
import joinquery.SqlConnector;
import joinquery.StringQueryCondition;
import joinquery.StringQueryOrderBy;
import joinquery.TableDef;
import joinquery.WrapperUtil;
import joinquery.util.ArrayUtil;
import joinquery.util.CollectionUtil;

public class JoinQueryWrapper
extends BaseQueryWrapper<JoinQueryWrapper> {
    public static JoinQueryWrapper create() {
        return new JoinQueryWrapper();
    }

    public JoinQueryWrapper select(QueryColumn ... queryColumns) {
        for (QueryColumn column : queryColumns) {
            if (column == null) continue;
            this.addSelectColumn(column);
        }
        return this;
    }

    public JoinQueryWrapper from(TableDef ... tableDefs) {
        for (TableDef tableDef : tableDefs) {
            this.from(new QueryTable(tableDef.getTableName()));
        }
        return this;
    }

    public JoinQueryWrapper from(String ... tables) {
        for (String table : tables) {
            this.from(new QueryTable(table));
        }
        return this;
    }

    public JoinQueryWrapper from(QueryTable ... tables) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            this.queryTables = new ArrayList();
            this.queryTables.addAll(Arrays.asList(tables));
        } else {
            for (QueryTable table : tables) {
                boolean contains = false;
                for (QueryTable queryTable : this.queryTables) {
                    if (!queryTable.isSameTable(table)) continue;
                    contains = true;
                }
                if (contains) continue;
                this.queryTables.add(table);
            }
        }
        return this;
    }

    public JoinQueryWrapper from(JoinQueryWrapper queryWrapper) {
        return this.from(new SelectQueryTable(queryWrapper));
    }

    public JoinQueryWrapper as(String alias) {
        if (CollectionUtil.isEmpty(this.queryTables)) {
            throw new IllegalArgumentException("query table must not be empty.");
        }
        if (this.queryTables.size() > 1) {
            throw new IllegalArgumentException("QueryWrapper.as(...) only support 1 table");
        }
        ((QueryTable)this.queryTables.get((int)0)).alias = alias;
        return this;
    }

    public JoinQueryWrapper where(QueryCondition queryCondition) {
        this.setWhereQueryCondition(queryCondition);
        return this;
    }

    public JoinQueryWrapper where(String sql) {
        this.setWhereQueryCondition(new StringQueryCondition(sql));
        return this;
    }

    public JoinQueryWrapper where(String sql, Object ... params) {
        this.setWhereQueryCondition(new StringQueryCondition(sql, params));
        return this;
    }

    public JoinQueryWrapper where(Map<String, Object> whereConditions) {
        if (whereConditions != null) {
            whereConditions.forEach((s, o) -> this.and(QueryCondition.create(new QueryColumn((String)s), o)));
        }
        return this;
    }

    public JoinQueryWrapper and(QueryCondition queryCondition) {
        return (JoinQueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.AND);
    }

    public JoinQueryWrapper and(String sql) {
        this.addWhereQueryCondition(new StringQueryCondition(sql), SqlConnector.AND);
        return this;
    }

    public JoinQueryWrapper and(String sql, Object ... params) {
        this.addWhereQueryCondition(new StringQueryCondition(sql, params), SqlConnector.AND);
        return this;
    }

    public JoinQueryWrapper or(QueryCondition queryCondition) {
        return (JoinQueryWrapper)this.addWhereQueryCondition(queryCondition, SqlConnector.OR);
    }

    public Joiner<JoinQueryWrapper> leftJoin(String table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> leftJoinIf(String table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> leftJoin(TableDef table) {
        return this.joining(" LEFT JOIN ", table.getTableName(), true);
    }

    public Joiner<JoinQueryWrapper> leftJoinIf(TableDef table, boolean condition) {
        return this.joining(" LEFT JOIN ", table.getTableName(), condition);
    }

    public Joiner<JoinQueryWrapper> leftJoin(JoinQueryWrapper table) {
        return this.joining(" LEFT JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> leftJoinIf(JoinQueryWrapper table, boolean condition) {
        return this.joining(" LEFT JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> rightJoin(String table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> rightJoinIf(String table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> rightJoin(JoinQueryWrapper table) {
        return this.joining(" RIGHT JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> rightJoinIf(JoinQueryWrapper table, boolean condition) {
        return this.joining(" RIGHT JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> innerJoin(String table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> innerJoinIf(String table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> innerJoin(TableDef table) {
        return this.innerJoinIf(table, true);
    }

    public Joiner<JoinQueryWrapper> innerJoinIf(TableDef table, boolean condition) {
        return this.joining(" INNER JOIN ", table.getTableName(), condition);
    }

    public Joiner<JoinQueryWrapper> innerJoin(JoinQueryWrapper table) {
        return this.joining(" INNER JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> innerJoinIf(JoinQueryWrapper table, boolean condition) {
        return this.joining(" INNER JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> fullJoin(String table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> fullJoinIf(String table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> fullJoin(JoinQueryWrapper table) {
        return this.joining(" FULL JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> fullJoinIf(JoinQueryWrapper table, boolean condition) {
        return this.joining(" FULL JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> crossJoin(String table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> crossJoinIf(String table, boolean condition) {
        return this.joining(" CROSS JOIN ", table, condition);
    }

    public Joiner<JoinQueryWrapper> crossJoin(JoinQueryWrapper table) {
        return this.joining(" CROSS JOIN ", table, true);
    }

    public Joiner<JoinQueryWrapper> crossJoinIf(JoinQueryWrapper table, boolean condition) {
        return this.joining(" CROSS JOIN ", table, condition);
    }

    protected Joiner<JoinQueryWrapper> joining(String type, String table, boolean condition) {
        Join join = new Join(type, table, condition);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<JoinQueryWrapper>((JoinQueryWrapper)this.AddJoin(join), join);
    }

    protected Joiner<JoinQueryWrapper> joining(String type, JoinQueryWrapper queryWrapper, boolean condition) {
        Join join = new Join(type, queryWrapper, condition);
        this.addJoinTable(join.getQueryTable());
        return new Joiner<JoinQueryWrapper>((JoinQueryWrapper)this.AddJoin(join), join);
    }

    public JoinQueryWrapper groupBy(String name) {
        this.addGroupByColumns(new QueryColumn(name));
        return this;
    }

    public JoinQueryWrapper groupBy(String ... names) {
        for (String name : names) {
            this.groupBy(name);
        }
        return this;
    }

    public JoinQueryWrapper groupBy(QueryColumn column) {
        this.addGroupByColumns(column);
        return this;
    }

    public JoinQueryWrapper groupBy(QueryColumn ... columns) {
        for (QueryColumn column : columns) {
            this.groupBy(column);
        }
        return this;
    }

    public JoinQueryWrapper having(QueryCondition queryCondition) {
        this.addHavingQueryCondition(queryCondition, SqlConnector.AND);
        return this;
    }

    public JoinQueryWrapper orderBy(QueryOrderBy ... orderBys) {
        for (QueryOrderBy queryOrderBy : orderBys) {
            this.addOrderBy(queryOrderBy);
        }
        return this;
    }

    public JoinQueryWrapper orderBy(String ... orderBys) {
        for (String queryOrderBy : orderBys) {
            this.addOrderBy(new StringQueryOrderBy(queryOrderBy));
        }
        return this;
    }

    public JoinQueryWrapper limit(Integer rows) {
        this.setLimitRows(rows);
        return this;
    }

    public JoinQueryWrapper offset(Integer offset) {
        this.setLimitOffset(offset);
        return this;
    }

    public JoinQueryWrapper limit(Integer offset, Integer rows) {
        this.setLimitOffset(offset);
        this.setLimitRows(rows);
        return this;
    }

    public JoinQueryWrapper datasource(String datasource) {
        this.setDatasource(datasource);
        return this;
    }

    public Object[] getValueArray() {
        Object[] whereValues = WrapperUtil.getValues(this.whereQueryCondition);
        Object[] havingValues = WrapperUtil.getValues(this.havingQueryCondition);
        return ArrayUtil.concat(whereValues, havingValues);
    }

    public Map<String, Object> getValueMap() {
        Map<String, Object> whereValues = WrapperUtil.getValuesMap(this.whereQueryCondition);
        Map<String, Object> havingValues = WrapperUtil.getValuesMap(this.havingQueryCondition);
        if (havingValues != null) {
            whereValues.putAll(havingValues);
        }
        return whereValues;
    }
}

