/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.Map;
import joinquery.JoinQueryWrapper;
import joinquery.dialect.DialectFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ibatis.builder.annotation.ProviderContext;

public class JoinQuerySqlProvider {
    protected static final Log logger = LogFactory.getLog(JoinQuerySqlProvider.class);
    public static final String QUERY = "$$query";

    private JoinQuerySqlProvider() {
    }

    public static JoinQueryWrapper getQueryWrapper(Map params) {
        return (JoinQueryWrapper)params.get(QUERY);
    }

    public static String selectListByQuery(Map params, ProviderContext context) {
        Map<String, Object> valueMap;
        JoinQueryWrapper queryWrapper = JoinQuerySqlProvider.getQueryWrapper(params);
        if (queryWrapper == null) {
            throw new IllegalArgumentException("joinQueryWrapper can not be null.");
        }
        String sql = DialectFactory.getDialect().buildSelectSql(queryWrapper);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        if (null != (valueMap = queryWrapper.getValueMap())) {
            params.putAll(valueMap);
        }
        return sql;
    }

    public static String selectCountByQuery(Map params, ProviderContext context) {
        Map<String, Object> valueMap;
        JoinQueryWrapper queryWrapper = JoinQuerySqlProvider.getQueryWrapper(params);
        if (queryWrapper == null) {
            throw new IllegalArgumentException("joinQueryWrapper can not be null.");
        }
        String sql = DialectFactory.getDialect().buildSelectCountSql(queryWrapper);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)sql);
        }
        if (null != (valueMap = queryWrapper.getValueMap())) {
            params.putAll(valueMap);
        }
        return sql;
    }
}

