/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.List;
import joinquery.QueryColumn;
import joinquery.QueryTable;
import joinquery.WrapperUtil;
import joinquery.dialect.IDialect;
import joinquery.util.SqlUtil;
import joinquery.util.StringUtil;

public class FunctionQueryColumn
extends QueryColumn {
    protected String fnName;
    protected QueryColumn column;

    public FunctionQueryColumn(String fnName, String column) {
        SqlUtil.keepColumnSafely(fnName);
        SqlUtil.keepColumnSafely(column);
        this.fnName = fnName;
        this.column = new QueryColumn(column);
    }

    public FunctionQueryColumn(String fnName, QueryColumn column) {
        SqlUtil.keepColumnSafely(fnName);
        this.fnName = fnName;
        this.column = column;
    }

    public String getFnName() {
        return this.fnName;
    }

    public void setFnName(String fnName) {
        this.fnName = fnName;
    }

    public QueryColumn getColumn() {
        return this.column;
    }

    public void setColumn(QueryColumn column) {
        this.column = column;
    }

    @Override
    public String toSelectSql(List<QueryTable> queryTables, IDialect dialect) {
        String sql = this.column.toSelectSql(queryTables, dialect);
        return StringUtil.isBlank(sql) ? "" : this.fnName + "(" + sql + ")" + WrapperUtil.buildAsAlias(this.alias);
    }

    @Override
    public QueryColumn as(String alias) {
        SqlUtil.keepColumnSafely(alias);
        this.alias = alias;
        return this;
    }
}

