/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.util.List;
import joinquery.QueryCondition;
import joinquery.QueryTable;
import joinquery.SqlConnector;
import joinquery.WrapperUtil;
import joinquery.dialect.IDialect;

public class Brackets
extends QueryCondition {
    private QueryCondition childCondition;

    public Brackets(QueryCondition childCondition) {
        this.childCondition = childCondition;
    }

    @Override
    public QueryCondition and(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.AND);
        return this;
    }

    @Override
    public QueryCondition or(QueryCondition nextCondition) {
        this.connectToChild(nextCondition, SqlConnector.OR);
        return this;
    }

    protected void connectToChild(QueryCondition nextCondition, SqlConnector connector) {
        this.childCondition.connect(nextCondition, connector);
    }

    @Override
    public Object getValue() {
        return this.checkEffective() ? WrapperUtil.getValues(this.childCondition) : null;
    }

    @Override
    public String toSql(List<QueryTable> queryTables, IDialect dialect) {
        StringBuilder sql = new StringBuilder();
        if (this.checkEffective()) {
            String childSql = this.childCondition.toSql(queryTables, dialect);
            QueryCondition effectiveBefore = this.getEffectiveBefore();
            if (effectiveBefore != null) {
                childSql = (Object)((Object)effectiveBefore.connector) + "(" + childSql + ")";
            }
            sql.append(childSql);
        }
        if (this.next != null) {
            return sql + this.next.toSql(queryTables, dialect);
        }
        return sql.toString();
    }

    @Override
    public String toString() {
        return "Brackets{childCondition=" + this.childCondition + '}';
    }
}

