/*
 * Decompiled with CFR 0.152.
 */
package joinquery;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import joinquery.Join;
import joinquery.QueryColumn;
import joinquery.QueryCondition;
import joinquery.QueryOrderBy;
import joinquery.QueryTable;
import joinquery.SqlConnector;
import joinquery.dialect.IDialect;
import joinquery.util.CollectionUtil;
import joinquery.util.StringUtil;

public class BaseQueryWrapper<T>
implements Serializable {
    protected List<QueryTable> queryTables;
    protected String datasource;
    protected List<QueryColumn> selectColumns;
    protected List<Join> joins;
    protected List<QueryTable> joinTables;
    protected QueryCondition whereQueryCondition;
    protected List<QueryColumn> groupByColumns;
    protected QueryCondition havingQueryCondition;
    protected List<QueryOrderBy> orderBys;
    protected Integer limitOffset;
    protected Integer limitRows;

    protected T addSelectColumn(QueryColumn queryColumn) {
        if (this.selectColumns == null) {
            this.selectColumns = new LinkedList<QueryColumn>();
        }
        this.selectColumns.add(queryColumn);
        return (T)this;
    }

    protected T AddJoin(Join join) {
        if (this.joins == null) {
            this.joins = new LinkedList<Join>();
        }
        this.joins.add(join);
        return (T)this;
    }

    protected T setWhereQueryCondition(QueryCondition queryCondition) {
        if (this.whereQueryCondition != null) {
            queryCondition.connect(this.whereQueryCondition, SqlConnector.AND);
        }
        this.whereQueryCondition = queryCondition;
        return (T)this;
    }

    protected T addWhereQueryCondition(QueryCondition queryCondition, SqlConnector connector) {
        if (queryCondition != null) {
            if (this.whereQueryCondition == null) {
                this.whereQueryCondition = queryCondition;
            } else {
                this.whereQueryCondition.connect(queryCondition, connector);
            }
        }
        return (T)this;
    }

    protected T addGroupByColumns(QueryColumn queryColumn) {
        if (this.groupByColumns == null) {
            this.groupByColumns = new LinkedList<QueryColumn>();
        }
        this.groupByColumns.add(queryColumn);
        return (T)this;
    }

    protected T addHavingQueryCondition(QueryCondition queryCondition, SqlConnector connector) {
        if (this.havingQueryCondition == null) {
            this.havingQueryCondition = queryCondition;
        } else {
            this.havingQueryCondition.connect(queryCondition, connector);
        }
        return (T)this;
    }

    protected T addOrderBy(QueryOrderBy queryOrderBy) {
        if (this.orderBys == null) {
            this.orderBys = new LinkedList<QueryOrderBy>();
        }
        this.orderBys.add(queryOrderBy);
        return (T)this;
    }

    protected void addJoinTable(QueryTable queryTable) {
        if (this.joinTables == null) {
            this.joinTables = new ArrayList<QueryTable>();
        }
        this.joinTables.add(queryTable);
    }

    protected List<QueryTable> getQueryTables() {
        return this.queryTables;
    }

    protected void setQueryTables(List<QueryTable> queryTables) {
        this.queryTables = queryTables;
    }

    protected String getDatasource() {
        return this.datasource;
    }

    protected void setDatasource(String datasource) {
        this.datasource = datasource;
    }

    protected List<QueryColumn> getSelectColumns() {
        return this.selectColumns;
    }

    protected void setSelectColumns(List<QueryColumn> selectColumns) {
        this.selectColumns = selectColumns;
    }

    protected List<Join> getJoins() {
        return this.joins;
    }

    protected void setJoins(List<Join> joins) {
        this.joins = joins;
    }

    protected List<QueryTable> getJoinTables() {
        return this.joinTables;
    }

    protected void setJoinTables(List<QueryTable> joinTables) {
        this.joinTables = joinTables;
    }

    protected QueryCondition getWhereQueryCondition() {
        return this.whereQueryCondition;
    }

    protected List<QueryColumn> getGroupByColumns() {
        return this.groupByColumns;
    }

    protected void setGroupByColumns(List<QueryColumn> groupByColumns) {
        this.groupByColumns = groupByColumns;
    }

    protected QueryCondition getHavingQueryCondition() {
        return this.havingQueryCondition;
    }

    protected List<QueryOrderBy> getOrderBys() {
        return this.orderBys;
    }

    protected void setOrderBys(List<QueryOrderBy> orderBys) {
        this.orderBys = orderBys;
    }

    protected Integer getLimitOffset() {
        return this.limitOffset;
    }

    protected void setLimitOffset(Integer limitOffset) {
        this.limitOffset = limitOffset;
    }

    protected Integer getLimitRows() {
        return this.limitRows;
    }

    protected void setLimitRows(Integer limitRows) {
        this.limitRows = limitRows;
    }

    protected StringBuilder getBaseQuerySql(IDialect dialect) {
        List<QueryTable> allTables = CollectionUtil.merge(this.queryTables, this.joinTables);
        StringBuilder sqlBuilder = new StringBuilder("SELECT ");
        if (this.selectColumns == null || this.selectColumns.isEmpty()) {
            sqlBuilder.append("*");
        } else {
            int index = 0;
            for (QueryColumn selectColumn : this.selectColumns) {
                String selectColumnSql = selectColumn.toSelectSql(allTables, dialect);
                sqlBuilder.append(selectColumnSql);
                if (index != this.selectColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
        sqlBuilder.append(" FROM ").append(StringUtil.join(", ", this.queryTables, queryTable -> queryTable.toSql(dialect)));
        this.buildJoinSql(sqlBuilder, dialect);
        return sqlBuilder;
    }

    protected void buildJoinSql(StringBuilder sqlBuilder, IDialect dialect) {
        if (this.joins != null && !this.joins.isEmpty()) {
            for (Join join : this.joins) {
                if (!join.checkEffective()) continue;
                sqlBuilder.append(join.toSql(this.queryTables, dialect));
            }
        }
    }

    protected void buildWhereSql(StringBuilder sqlBuilder, List<QueryTable> queryTables, IDialect dialect) {
        String whereSql;
        if (this.whereQueryCondition != null && StringUtil.isNotBlank(whereSql = this.whereQueryCondition.toSql(queryTables, dialect))) {
            sqlBuilder.append(" WHERE ").append(whereSql);
        }
    }

    protected void buildGroupBySql(StringBuilder sqlBuilder, List<QueryTable> queryTables, IDialect dialect) {
        if (this.groupByColumns != null && !this.groupByColumns.isEmpty()) {
            sqlBuilder.append(" GROUP BY ");
            int index = 0;
            for (QueryColumn groupByColumn : this.groupByColumns) {
                String groupBy = groupByColumn.toConditionSql(queryTables, dialect);
                sqlBuilder.append(groupBy);
                if (index != this.groupByColumns.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }

    protected void buildHavingSql(StringBuilder sqlBuilder, List<QueryTable> queryTables, IDialect dialect) {
        if (this.havingQueryCondition != null) {
            this.havingQueryCondition.index = 100000;
            String havingSql = this.havingQueryCondition.toSql(queryTables, dialect);
            if (StringUtil.isNotBlank(havingSql)) {
                sqlBuilder.append(" HAVING ").append(havingSql);
            }
        }
    }

    protected void buildOrderBySql(StringBuilder sqlBuilder, List<QueryTable> queryTables, IDialect dialect) {
        if (this.orderBys != null && !this.orderBys.isEmpty()) {
            sqlBuilder.append(" ORDER BY ");
            int index = 0;
            for (QueryOrderBy orderBy : this.orderBys) {
                sqlBuilder.append(orderBy.toSql(queryTables, dialect));
                if (index != this.orderBys.size() - 1) {
                    sqlBuilder.append(", ");
                }
                ++index;
            }
        }
    }
}

